/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Apr 13, 2004
 * Time: 4:12:17 PM
 * To change this template use Options | File Templates.
 */
public class ManageGroupConstantsDialog extends JDialog {
    final MetadataEditor editor;
    private TableModel theModel;
    private ArrayList theConstantNames;
    private ArrayList theConstantValues;
    protected MetaConstantGroup theGroup;
    protected String marshalledConstantName; // these are written-to/read-from between dialogs
    protected String marshalledConstantValue;
    private boolean dialogModified = false;

    JATable tblConstants = null;

    public ManageGroupConstantsDialog (MetadataEditor editor, MetaConstantGroup group) {
        super(editor, "Manage Constants in Group", true);
        tblConstants = new JATable();
        this.editor = editor;
        this.theGroup = group;
        createDataForInitialTableModel();
        initDisplay("Constants for \"" + group.sClassName + "\"", tblConstants);
        populateDisplay();
    }

    private void createDataForInitialTableModel () {
        theConstantNames = new ArrayList();
        theConstantValues = new ArrayList();

        ArrayList constants = theGroup.getConstantList();

        for (int iConstant = 0; iConstant < constants.size(); iConstant++) {
            String sConstantName = (String) constants.get(iConstant);
            String sConstantValue = theGroup.get(sConstantName);
            theConstantNames.add(sConstantName);
            theConstantValues.add(sConstantValue);
        }
    }

    private void populateDisplay () {
        tblConstants.setModel(new ConstantsTableModel());
        //tblConstants.set
    }

    private void initDisplay (String sCaption, JComponent list) {
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel(new BorderLayout());
        pnlConstants.setBorder(BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add(new JScrollPane(list), BorderLayout.CENTER);
        JAButton btnAdd = new JAButton("Add");
        JAButton btnEdit = new JAButton("Edit");
        JAButton btnDelete = new JAButton("Delete");

        btnAdd.addActionListener(new AddConstantAction(this));
        btnEdit.addActionListener(new EditConstantAction(this));
        btnDelete.addActionListener(new DeleteConstantAction(this));

        JAPanel pnlButtons = new JAPanel(new FlowLayout(FlowLayout.LEFT, 5, 5));
        pnlButtons.add(btnAdd);
        pnlButtons.add(btnEdit);
        pnlButtons.add(btnDelete);
        pnlConstants.add(pnlButtons, BorderLayout.SOUTH);
        pane.add(pnlConstants, BorderLayout.CENTER);
        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");

        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        pnlDialogButtons.add(btnCancel);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        setSize(400, 300);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing (WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageGroupConstantsDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });


    }

    class ConstantsTableModel extends AbstractTableModel {
        private int rowCount;

        public ConstantsTableModel () {
            rowCount = theConstantNames.size();
        }

        public String getColumnName (int column) {
            if (column == 0)
                return "Name";
            else
                return "Value";
        }

        public int getRowCount () {
            return rowCount;
        }

        public int getColumnCount () {
            return 2;
        }

        public Object getValueAt (int rowIndex, int columnIndex) {
            String sConstantName = (String) theConstantNames.get(rowIndex);
            String sConstantValue = (String) theConstantValues.get(rowIndex);
            if (columnIndex == 0)
                return sConstantName;
            else
                return sConstantValue;
        }

    }

    class EditConstantAction implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public EditConstantAction (ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedRow = dialog.tblConstants.getSelectedRow();
            if (iSelectedRow == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a constant before you can edit it.", "No Constant Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            marshalledConstantName = (String) dialog.tblConstants.getValueAt(iSelectedRow, 0);
            marshalledConstantValue = (String) dialog.tblConstants.getValueAt(iSelectedRow, 1);

            EditGroupConstantsDialog editDialog = new EditGroupConstantsDialog(dialog, "Edit Constant", true);
            editDialog.show();
            if (marshalledConstantName != null) {
                // we need to modify the constant...
                theConstantNames.set(iSelectedRow, marshalledConstantName);
                theConstantValues.set(iSelectedRow, marshalledConstantValue);
                populateDisplay();
                dialogModified = true;
            }

        }

    }

    class AddConstantAction implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public AddConstantAction (ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            EditGroupConstantsDialog editDialog = new EditGroupConstantsDialog(dialog, "Add Constant To Group", false);
            editDialog.show();
            if (marshalledConstantName != null) {
                // there is a constant to add to the list...
                theConstantNames.add(marshalledConstantName);
                theConstantValues.add(marshalledConstantValue);
                populateDisplay();
                dialogModified = true;
            }
        }
    }

    class DeleteConstantAction implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public DeleteConstantAction (ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedRow = dialog.tblConstants.getSelectedRow();
            if (iSelectedRow == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a constant before you can delete it.", "No Constant Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String sConstantName = (String) dialog.tblConstants.getValueAt(iSelectedRow, 0);
            Object sConfirmationText = "Are you sure you want to delete the constant  \"" + sConstantName + "\" ?";
            String sConfirmationTitle = "Delete Constant";
            int optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
            if (iChoice == JOptionPane.YES_OPTION) {
                // Update the list...
                theConstantNames.remove(iSelectedRow);
                theConstantValues.remove(iSelectedRow);
                populateDisplay();
                dialogModified = true;
            }
        }
    }

    class CancelAction implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public CancelAction (ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            if (dialog.dialogModified == true) {
                Object sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == JOptionPane.YES_OPTION) {
                    dialog.hide();
                }
            } else
                hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageGroupConstantsDialog dialog;

        public OkAction (ManageGroupConstantsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            if (dialogModified == true)
                dialog.editor.setMetadataModified(true);
            else
                return; // nothing to save!

            theGroup.clearConstants();
            for (int iConstant = 0; iConstant < theConstantNames.size(); iConstant++) {
                theGroup.set((String) theConstantNames.get(iConstant), (String) theConstantValues.get(iConstant));
            }

            dialog.hide();

        }
    }

}
