/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaClass;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.table.TableModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Apr 13, 2004
 * Time: 4:12:17 PM
 */
public class ManageClassDialog extends JADialog {
    final MetadataEditor theEditor;
    ManageClassPageAttributes pageAttributes;
    private TableModel theModel;
    protected MetaClass theClass;
    private boolean dialogModified = false;

    JATextArea txtComments = null;

    public ManageClassDialog (MetadataEditor editor, MetaClass metaClass) {
        super(editor, "Manage Class: " + metaClass.getMetadata().sClassName, true, false);
        txtComments = new JATextArea();
        this.theEditor = editor;
        this.theClass = metaClass;
        initDisplay("Class \"" + metaClass.getMetadata().sClassName + "\"");
        populateDisplay();
    }

    public boolean isDialogModified() {
        return dialogModified;
    }

    private void populateDisplay () {
        txtComments.setText(theClass.getMetadata().sClassComment);
    }

    private void initDisplay (String sCaption) {
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JATabbedPane tabbedPane = new JATabbedPane();
        pageAttributes = new ManageClassPageAttributes(this, theClass);
        JAPanel pageProperties = new ClassPropertiesPage(this, theClass.getMetadata());
        JAPanel pageComments = new JAPanel(new BorderLayout());


        pageComments.add(new JScrollPane(txtComments), BorderLayout.CENTER);

        tabbedPane.add("Attributes", pageAttributes);
        tabbedPane.add("Properties", pageProperties);
        tabbedPane.add("Comments", pageComments);

        pane.add(tabbedPane, BorderLayout.CENTER);

        //JAPanel pnlConstants = new JAPanel(new BorderLayout());
        //pnlConstants.setBorder(BorderFactory.createTitledBorder(sCaption));
        //pnlConstants.add(new JScrollPane(tblDetails), BorderLayout.CENTER);

        //JAPanel pnlButtons = new JAPanel(new FlowLayout(FlowLayout.LEFT, 5, 5));
        //pane.add(pnlButtons, BorderLayout.SOUTH);
        //pane.add(pnlConstants, BorderLayout.CENTER);
        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));
        JAButton btnOK = new JAButton("OK");
        //JAButton btnCancel = new JAButton("Cancel");

        btnOK.addActionListener(new OkAction(this));
        //btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        //pnlDialogButtons.add(btnCancel);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        //setSize(600, 350);
        pack();
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing (WindowEvent e) {
                // todo: implement a "cancel" operation on the dialog
                //CancelAction cancelAction = new CancelAction(ManageClassDialog.this);
                //cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });


    }

    class CancelAction implements ActionListener {
        private final ManageClassDialog dialog;

        public CancelAction (ManageClassDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
//            if (dialog.dialogModified == true) {
//                Object sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
//                String sConfirmationTitle = "Cancel Changes";
//                int optionType = JOptionPane.YES_NO_OPTION;
//                int messageType = JOptionPane.QUESTION_MESSAGE;
//                int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
//                if (iChoice == JOptionPane.YES_OPTION) {
//                    dialog.hide();
//                }
//            } else
                hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageClassDialog dialog;

        public OkAction (ManageClassDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            //if (dialogModified == true)
            dialogModified = true;
                dialog.theEditor.setMetadataModified(true);
            //else
            //    return; // nothing to save!

            pageAttributes.commitAttributes();

            // Comments...
            String sComments = txtComments.getText();
            if (sComments.equals("")) sComments = null;
            theClass.getMetadata().sClassComment = sComments;

            dialog.hide();

        }

    }



}
