/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyTableMouseListener implements MouseListener {
    PropertyTable thePropertyTable;

    public PropertyTableMouseListener(PropertyTable thePropertyTable) {
        this.thePropertyTable = thePropertyTable;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (thePropertyTable.theModel.theMetaObject == null)
            return;

        Point pt = evt.getPoint();
        int iRow = thePropertyTable.rowAtPoint(pt);
        int iCol = thePropertyTable.columnAtPoint(pt);

        showHelper(iRow, iCol);
    }

    private void showHelper(int iRow, int iCol) {
        String sPropertyName = (String) thePropertyTable.getValueAt(iRow, 0);
        int iEqual = sPropertyName.indexOf("=");
        if (iEqual != -1)
            sPropertyName = sPropertyName.substring(0, iEqual);
        sPropertyName = sPropertyName.trim();
        MetaPropertyDescriptor theProp = thePropertyTable.theModel.theMetaObject.theClass.getProperty(sPropertyName, true);
        if (theProp != null) {
            String sHelperClass = theProp.getHelperClass();
            if (iCol == 0 && (sHelperClass != null) && (sHelperClass.length() > 0)) {
                try {
                    Class helperClass = Class.forName(sHelperClass);
                    Constructor helperConstructor = helperClass.getConstructor((Class[])null);
                    Object helper = helperConstructor.newInstance((Object[])null);

                    Class[] paramClasses = new Class[3];
                    paramClasses[0] = MetaObject.class;
                    paramClasses[1] = String.class;
                    paramClasses[2] = SuperDesignCockpit.class;

                    Method executeMethod = helperClass.getMethod("execute", paramClasses);
                    Object[] paramValues = new Object[3];
                    paramValues[0] = thePropertyTable.theModel.theMetaObject;
                    paramValues[1] = sPropertyName;
                    paramValues[2] = thePropertyTable.theDesignCockpit;
                    boolean bProjectModified = ((Boolean)executeMethod.invoke(helper, paramValues)).booleanValue();
                    if (bProjectModified)
                    {
                        thePropertyTable.theDesignCockpit.getPropertyInspectorController().refreshPropertyInspector();
                        thePropertyTable.theDesignCockpit.theCurrentDesignProject.theMetaProject.setProjectChangedState(true);
                    }
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }

            } else if (theProp.bAllowMultipleValues) {
                if (thePropertyTable.theArrayValueEditor != null)
                    thePropertyTable.theArrayValueEditor.close();
                thePropertyTable.theArrayValueEditor = new IDEArrayValueEditor(thePropertyTable.theModel.theMetaObject, sPropertyName, thePropertyTable.theDesignCockpit);
            }
        }
    }

    private void showHelperOrig(int iRow, int iCol) {
        String sPropertyName = (String) thePropertyTable.getValueAt(iRow, 0);
        int iEqual = sPropertyName.indexOf("=");
        if (iEqual != -1)
            sPropertyName = sPropertyName.substring(0, iEqual);
        sPropertyName = sPropertyName.trim();
        MetaPropertyDescriptor theProp = thePropertyTable.theModel.theMetaObject.theClass.getProperty(sPropertyName, true);
        if (theProp != null) {
            String sHelperClass = theProp.getHelperClass();
            if (iCol == 0 && (sHelperClass != null) && (sHelperClass.length() > 0)) {
                try {
                    Class theHelperClass = Class.forName(sHelperClass);
                    Class[] theParamClass = new Class[3];
                    Object[] theParamObject = new Object[3];
                    theParamObject[0] = thePropertyTable.theModel.theMetaObject;
                    theParamClass[0] = thePropertyTable.theModel.theMetaObject.getClass();
                    theParamObject[1] = sPropertyName;
                    theParamClass[1] = sPropertyName.getClass();
                    theParamObject[2] = thePropertyTable.theDesignCockpit;
                    theParamClass[2] = SuperDesignCockpit.class;
                    Constructor theConstructor = theHelperClass.getConstructor(theParamClass);
                    theConstructor.newInstance(theParamObject);
                } catch (ClassNotFoundException e) {
                } catch (NoSuchMethodException e) {
                } catch (InstantiationException e) {
                } catch (IllegalAccessException e) {
                } catch (InvocationTargetException e) {
                }
            } else if (theProp.bAllowMultipleValues) {
                if (thePropertyTable.theArrayValueEditor != null)
                    thePropertyTable.theArrayValueEditor.close();
                thePropertyTable.theArrayValueEditor = new IDEArrayValueEditor(thePropertyTable.theModel.theMetaObject, sPropertyName, thePropertyTable.theDesignCockpit);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

}
