/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;

import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;

public class ObjectTreeViewModelListener implements TreeModelListener {
    SuperDesignCockpit theDesignCockpit = null;

    public ObjectTreeViewModelListener(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void treeNodesChanged(TreeModelEvent e) {
        ObjectTreeViewNode node;
        node = (ObjectTreeViewNode)
                (e.getTreePath().getLastPathComponent());

        /*
         * If the event lists children, then the changed
         * node is the child of the node we've already
         * gotten.  Otherwise, the changed node and the
         * specified node are the same.
         */
        try {
            int index = e.getChildIndices()[0];
            node = (ObjectTreeViewNode)
                    (node.getChildAt(index));
        } catch (NullPointerException exc) {
        }
//            if (node.getMetaObject() != null) {
//                // Look up name to see if it is already used.
//                if (theDesignCockpit.getDesignProject().findObject((String)node.getUserObject())==null)
//                    // Change the name of the object.
//                    node.getMetaObject().theName = (String)node.getUserObject();
//                else { // Give an error and fix the label of the node.
//                    JOptionPane pane = new JOptionPane("Identifier "+(String)node.getUserObject()+" is already used in this project.",
//                                                       JOptionPane.ERROR_MESSAGE);
//                    JDialog dialog = pane.createDialog(theDesignCockpit.theObjectTreeViewPane, "Object Naming Error");
//                    dialog.show();
//                    node.setUserObject(node.getMetaObject().theName);
//                }
//            }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }
}
