/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.DNDTree;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;

import javax.swing.tree.*;
import javax.swing.*;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 27, 2003
 * Time: 6:36:33 PM
 * To change this template use Options | File Templates.
 * <p/>
 * 20040715, acg, Added Drag and Drop
 */
public class ObjectTreeView extends DNDTree {
    public SuperDesignCockpit theCockpit = null;
    public DefaultTreeModel theModel = null;

    public ObjectTreeView(DefaultTreeModel objModel,
                          SuperDesignCockpit objCockpit) {
        super(objModel);
        theCockpit = objCockpit;
        theModel = objModel;
        if (theCockpit.isCustomizing())
            this.setRootVisible(false); // Alex doesn't want the "Program" node to be visible when customizing
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            TreeNode fromParent = fromNode.getParent();
            TreeNode toParent = dropnode.getParent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode) dropnode.getParent();
            int toIndex = parent.getIndex(dropnode);
            int fromIndex = parent.getIndex(fromNode);

            if (!dropnode.equals(fromNode) && fromParent.equals(toParent)) {
                ObjectTreeViewNode theParent = (ObjectTreeViewNode) toParent;
                MetaObject objParent = theParent.getMetaObject();

                MetaObject fromObj = ((ObjectTreeViewNode) fromNode).getMetaObject();
                if (fromObj.isTabPage()) { // we must prevent tabpages moving!
                    return;
                }

                MetaObject toObj = ((ObjectTreeViewNode) dropnode).getMetaObject();

                objParent.theDesignProject.setProjectChangedState(true);
                MetaObject fromObjCurrentPrev = fromObj.thePreviousObject;
                MetaObject fromObjCurrentNext = fromObj.theNextObject;
                MetaObject toObjCurrentPrev = toObj.thePreviousObject;
                MetaObject toObjCurrentNext = toObj.theNextObject;
                MetaObject objFirst = objParent.theFirstChild;
                MetaObject objLast = objParent.theLastChild;

                if (fromObj.equals(objFirst)) {
                    objParent.theFirstChild = fromObjCurrentNext;
                }

                if (fromObj.equals(objLast)) {
                    objParent.theLastChild = fromObjCurrentPrev;
                }

                if (toObj.equals(objLast)) {
                    objParent.theLastChild = fromObj;
                }

                if (toObj.equals(objFirst)) {
                    objParent.theFirstChild = fromObj;
                }

                // Detach the source MetaObject from where it is now.
                if (fromObjCurrentNext != null)
                    fromObjCurrentNext.thePreviousObject = fromObjCurrentPrev;
                if (fromObjCurrentPrev != null)
                    fromObjCurrentPrev.theNextObject = fromObjCurrentNext;

                // Attach the source MetaObject to it's new location
                if (fromIndex > toIndex) // Inserted above the dest node
                {
                    fromObj.thePreviousObject = toObjCurrentPrev;
                    fromObj.theNextObject = toObj;

                    // Fixup the destination MetaObject
                    toObj.thePreviousObject = fromObj;
                    if (toObjCurrentPrev != null)
                        toObjCurrentPrev.theNextObject = fromObj;
                } else    // Inserted below the dest node
                {
                    fromObj.thePreviousObject = toObj;
                    fromObj.theNextObject = toObjCurrentNext;

                    // Fixup the destination MetaObject
                    toObj.theNextObject = fromObj;
                    if (toObjCurrentNext != null)
                        toObjCurrentNext.thePreviousObject = fromObj;
                }

                super.dragDropEnd(event);

                TreePath path = new TreePath(fromNode.getPath());
                if (path != null)
                    setSelectionPath(path);
                updateUI();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        if (theCockpit != null)
            setFolderIcons();   // we need to set the icons back after an updateUI()
    }

    public void setFolderIcons() {
        setCellRenderer(new TreeCellRenderer());
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer) getCellRenderer();
        renderer.setOpenIcon(theCockpit.folderCubeIcon);
        renderer.setClosedIcon(theCockpit.folderCubeIcon);
        renderer.setLeafIcon(theCockpit.CubeIcon);
    }

    class TreeCellRenderer extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value,
                                                      boolean sel,
                                                      boolean expanded,
                                                      boolean leaf, int row,
                                                      boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

            ObjectTreeViewNode node = (ObjectTreeViewNode) value;
            MetaObject metaObject = node.getMetaObject();
            Icon objClassIcon = null;
            HammerImageIconFactory theIconFactory = new HammerImageIconFactory(theCockpit.getClassLoader());
            if (metaObject != null && !theCockpit.isCustomizing())
            {
                String metadataIcon=metaObject.theClass.getMetadata().sDisplayClassIcon;

                if(metadataIcon.compareTo("")!=0)
                {
                    objClassIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                    setIcon(objClassIcon);
                }
            }
            else if (metaObject != null && theCockpit.isCustomizing()){
                if( theCockpit.theCustomizer.getInstanceIcon(metaObject)==null)
                {
                    String metadataIcon=metaObject.theClass.getMetadata().sDisplayClassIcon;
                    if(metadataIcon.compareTo("")!=0)
                    {
                        objClassIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                        setIcon(objClassIcon);
                    }
                }
                else
                    setIcon( theCockpit.theCustomizer.getInstanceIcon(metaObject) );
                setText( theCockpit.theCustomizer.getObjectDisplayName(metaObject) );
            }

            return this;
        }
    }

}
