/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;


/*
=====================================================================

  JCheckTreeTest.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import ch.abacus.lib.ui.renderer.common.BasicTreeCellRenderer;
import ch.abacus.lib.ui.renderer.common.BasicTreeNode;
import ch.abacus.lib.ui.renderer.common.CheckTreeNode;
import ch.abacus.lib.ui.renderer.common.PLAF;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;

import javax.swing.*;
import java.awt.*;

public class JCheckTreeTest extends JAPanel {
    public JCheckTreeTest() {
        setLayout(new GridLayout(1, 1));
        CheckTreeNode root = new CheckTreeNode(
                BasicTreeNode.createComputer("Root"));
        root.add(makeNode("Node 1", "Child", 7));
        root.add(makeNode("Node 2", "Child", 7));
        root.add(makeNode("Node 3", "Child", 7));
        root.add(makeNode("Node 4", "Child", 7));
        root.add(makeNode("Node 5", "Child", 7));
        root.add(makeNode("Node 6", "Child", 7));
        root.add(makeNode("Node 7", "Child", 7));

        JCheckTree tree = new JCheckTree(root);
        tree.setCellRenderer(new BasicTreeCellRenderer());
        tree.setEditorRenderer(new BasicTreeCellRenderer());
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);

        add(new JAScrollPane(tree));
    }

    public CheckTreeNode makeNode(
            String name, String prefix, int count) {
        CheckTreeNode node = new CheckTreeNode(
                BasicTreeNode.createDrive(name));
        for (int i = 0; i < count; i++) {
            node.add(new CheckTreeNode(
                    BasicTreeNode.createFolder(prefix + " " + (i + 1))));
        }
        return node;
    }

    public static void main(String[] args) {
        PLAF.setNativeLookAndFeel(true);

        JFrame frame = new JFrame("JCheckTree Test");
        frame.getContentPane().setLayout(new GridLayout(1, 1));
        frame.getContentPane().add(new JCheckTreeTest());
        frame.setSize(200, 400);
        frame.show();
    }
}

