/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;


/*
=====================================================================

  JCheckTree.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import ch.abacus.lib.ui.renderer.common.CheckTreeCellEditor;
import ch.abacus.lib.ui.renderer.common.CheckTreeCellRenderer;
import ch.abacus.lib.ui.JATree;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class JCheckTree extends JATree {
    public JCheckTree(TreeNode root) {
        super(root);
        super.setCellRenderer(new CheckTreeCellRenderer(this));
        setCellEditor(new CheckTreeCellEditor(this));
        setEditable(true);
    }

    public JCheckTree(DefaultTreeModel model) {
        super(model);
        super.setCellRenderer(new CheckTreeCellRenderer(this));
        setCellEditor(new CheckTreeCellEditor(this));
        setEditable(true);
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        super.setCellRenderer(new CheckTreeCellRenderer(this, renderer));
    }

    public void setEditorRenderer(TreeCellRenderer renderer) {
        setCellEditor(new CheckTreeCellEditor(this, renderer));
    }
}

