/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.Lizard;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeJumper;
import ch.abacus.lib.ui.JATabbedPane;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.StringReader;

public class IDESourceViewer extends JATabbedPane {
    //IDESourceEditor theCodeEditor = null;
    IIDESourceEditor theCodeEditor = null;
    IDESourceTextArea theMessagesEditor = null;
    SuperDesignCockpit theDesignCockpit;
    public MessageSourceMouseListener theListener = null;

    public IDESourceViewer(SuperDesignCockpit objDesignCockpit) {
        super(JATabbedPane.TOP);
        theDesignCockpit = objDesignCockpit;
        addChangeListener(new TabbedPaneListener());

        String editPlugin = objDesignCockpit.theConfigurationManager.getConfigurationVariable("EditorPlugin",null);

        if(editPlugin==null)
        {
            theCodeEditor = new IDESourceEditor();
            theCodeEditor.setDesignCockpit(objDesignCockpit);
        }
        else{
            Class thePluginEditorClass;

            try
            {
                thePluginEditorClass =  Class.forName(editPlugin);
                theCodeEditor = (IIDESourceEditor)thePluginEditorClass.newInstance();
                theCodeEditor.setDesignCockpit(theDesignCockpit);
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }
        }

        theMessagesEditor = new IDESourceTextArea();

        theMessagesEditor.addCaretListener(new IDESourceCaretListener(theDesignCockpit));
        theCodeEditor.addCaretListener(new IDESourceCaretListener(theDesignCockpit));
        theCodeEditor.thePopupMenu = new IDEEditorPopupMenu(theCodeEditor, objDesignCockpit);
        theCodeEditor.getTextEdit().addMouseListener(new IDEEditorMouseListener(theCodeEditor.getTextEdit(), theCodeEditor.thePopupMenu));
        theMessagesEditor.thePopupMenu = new IDEEditorPopupMenu(theMessagesEditor, objDesignCockpit);
        theMessagesEditor.addMouseListener(new IDEEditorMouseListener(theMessagesEditor, theMessagesEditor.thePopupMenu));

        // Add tabs for code and html editor
        String sCodePageLabel = theDesignCockpit.theLanguageManager.getMessage("MessagesPane.CodePage.label", "Event Code");
        String sMessagesPageLabel = theDesignCockpit.theLanguageManager.getMessage("MessagesPane.MessagesPage.label", "Messages");
        String sObjectCodePageLabel = theDesignCockpit.theLanguageManager.getMessage("MessagesPane.ObjectCodePage.label", "Object Code");

        if(objDesignCockpit.getProgramMode()==objDesignCockpit.JAVABUILDER)
        {
            if(theCodeEditor.getContainer()!=null)
                addTab(sCodePageLabel, theCodeEditor.getContainer());
            else
                addTab(sCodePageLabel, theCodeEditor.getTextEdit());
        }
        addTab(sMessagesPageLabel, theMessagesEditor);

        theListener = new MessageSourceMouseListener(theDesignCockpit);
        theMessagesEditor.addMouseListener(theListener);
    }

    public Component getActiveEditor() {
        Component theSelectedComponent = getSelectedComponent();
        if (theSelectedComponent.equals(theMessagesEditor) == true)
            return theMessagesEditor;
        if (theSelectedComponent.equals(theCodeEditor) == true)
            return theCodeEditor;
        return null;
    }

    public void setCodeText(String sText) {
        StringReader theStringReader = new StringReader(sText);
        try {
            theCodeEditor.read(theStringReader, null);
        } catch (java.io.IOException e1) {
        }
    }

    public String getCodeText() {
        return theCodeEditor.getText();
    }

    public void setMessagesText(String sText) {
        theMessagesEditor.setText(sText);
    }

    public void showErrorMessage(String sText) {
        theMessagesEditor.setText(sText);
        showMessageEditor();
    }

    public void showCodeEditor(int iRow, int iColumn) {
        Component theSelectedComponent = getSelectedComponent();
        if (theSelectedComponent.equals(theCodeEditor) == false) {
            int iSelectedIndex = getSelectedIndex();
            setEnabledAt(iSelectedIndex, false);
            if (theCodeEditor.hasContainer())
                setSelectedComponent(theCodeEditor.getContainer());
            else
                setSelectedComponent(theCodeEditor.getTextEdit());
        }
    }

    public void showCodeEditor() {
        showCodeEditor(0, 0);
    }

    public void showMessageEditor() {
        Component theSelectedComponent = getSelectedComponent();
        if (theSelectedComponent.equals(theMessagesEditor) == false) {
            int iSelectedIndex = getSelectedIndex();
            setEnabledAt(iSelectedIndex, false);
            setSelectedComponent(theMessagesEditor);
        }
    }

    /**
     * Will cause the output to be displayed immediately 
     */
    public void update() {
        paintImmediately(0, 0, getWidth(), getWidth());
    }

    class TabbedPaneListener implements ChangeListener {
        int selectedIndex = -1; // -1 = nothing has ever been selected.
        JATabbedPane tp;         // current pane.

        public void stateChanged(ChangeEvent evt) {
            tp = (JATabbedPane) evt.getSource();
            if ((selectedIndex == -1) || (selectedIndex != tp.getSelectedIndex())) {
                tp.setEnabledAt(tp.getSelectedIndex(), false);
                if (selectedIndex != -1)
                    tp.setEnabledAt(selectedIndex, true);
            }
            selectedIndex = tp.getSelectedIndex();
        }
    }

    class MessageSourceMouseListener extends MouseAdapter {
        UIFactoryCodeJumper theCodeJumper;
        SuperDesignCockpit theDesignCockpit = null;

        MessageSourceMouseListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void setCodeJumper(UIFactoryCodeJumper objCodeJumper) {
            theCodeJumper = objCodeJumper;
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() != 2)
                return;
            if (theCodeJumper != null) {
                IDESourceTextArea theMessageViewer = (IDESourceTextArea) evt.getSource();
                String sSelection = theMessageViewer.getSelectedText();
                if ((sSelection != null) && (sSelection.length() != 0)) {
                    try {
                        int iLineNumber = (new Integer(sSelection)).intValue();
                        if (iLineNumber != 0) {
                            int iJumpClass = theCodeJumper.getJumpPointClass(iLineNumber);
                            int iJumpType = theCodeJumper.getJumpPointType(iLineNumber);
                            String sClassName = theCodeJumper.getClassName(iLineNumber);
                            String sListenerName = "";
                            if (iJumpClass == UIFactoryCodeJumper.JUMPCLASS_LISTENER) {
                                sListenerName = theCodeJumper.getListenerName(iLineNumber);
                                // Look for the syntactic sugar written by the code generator
                                // and referenced by the blueprint object of the ui factory.
                                int iMatch = sListenerName.indexOf("$$$");
                                String sObjectIdentifier = "";
                                if (iMatch != -1)
                                    sObjectIdentifier = sListenerName.substring(0, iMatch);
                                else
                                    return;  // cannot find object.
                                String sMethodName = theCodeJumper.getMethodName(iLineNumber);
                                // Find the object.
                                MetaObject theMetaObject = theDesignCockpit.getDesignProject().findObject(sObjectIdentifier);
                                // Select the object (among other things, this loads the method list)
                                if (theMetaObject != null) {
                                    theDesignCockpit.setSelectedObject(theMetaObject);
                                    // Select the method.
                                    //theDesignCockpit.theMethodList.selectMethod(sMethodName);
                                    // Bring the code editor up.
                                    showCodeEditor();
                                }
                            } else {
                                if (iJumpType == UIFactoryCodeJumper.JUMPPOINT_NONE)
                                    return;
                                // Find the design class for sClassName.
                                // Load the class edit tool with the design class.
                                MetaClass theMetaClass =
                                        theDesignCockpit.getDesignProject().findClass(sClassName);
                                if (theMetaClass == null)
                                    return;
                                Lizard theClassEditor = new Lizard(theMetaClass, theDesignCockpit.getDesignProject().theMetaProject.getMetadataDispenser(),theDesignCockpit);
                                switch (iJumpType) {
                                    case UIFactoryCodeJumper.JUMPPOINT_MEMBERDATA:
                                        String sMemberDataName = theCodeJumper.getMemberDataName(iLineNumber);
                                        // Select the member data entry.
                                        theClassEditor.theViewerTabs.setCurrentPanel(
                                                theClassEditor.theViewerTabs.theMemberDataViewer);
                                        theClassEditor.theViewerTabs.theMemberDataViewer.selectMemberData(sMemberDataName);
                                        break;
                                    case UIFactoryCodeJumper.JUMPPOINT_METHOD:
                                        String sMethodName = theCodeJumper.getMethodName(iLineNumber);
                                        // Select the method entry.
                                        theClassEditor.theViewerTabs.setCurrentPanel(
                                                theClassEditor.theViewerTabs.theMethodViewer);
                                        theClassEditor.theViewerTabs.theMethodViewer.selectMethod(sMethodName);
                                        break;
                                    case UIFactoryCodeJumper.JUMPPOINT_PROPERTY:
                                        String sPropertyName = theCodeJumper.getPropertyName(iLineNumber);
                                        // Select the propety entry.
                                        theClassEditor.theViewerTabs.setCurrentPanel(
                                                theClassEditor.theViewerTabs.thePropertyViewer);
                                        theClassEditor.theViewerTabs.thePropertyViewer.selectProperty(sPropertyName);
                                        break;
                                }
                            }
                        }
                    } catch (Exception e) {  // Throw all away. No problem here.
                    }
                }
            }
        }
    }

}
