/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import org.comedia.text.CJavaHighlighter;

import javax.swing.*;
import javax.swing.text.Keymap;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import java.awt.*;
import java.awt.event.*;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Reader;
import java.io.IOException;
import java.util.Hashtable;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:35:12 PM
 * To change this template use Options | File Templates.
 */
public class IDESourceEditor extends IIDESourceEditor
{
    private IDESourceEditorImp ideSourceEditor = null;
    private SuperDesignCockpit objDesignCockpit = null;

    public IDESourceEditor()
    {
        init();
    }

    private void init()
    {
        ideSourceEditor = new IDESourceEditorImp();
    }
    public void setCode(String sCode)
    {
        ideSourceEditor.setCode(sCode);
    }

    public String getCode()
    {
        return ideSourceEditor.getText();
    }

    public void setDesignCockpit(SuperDesignCockpit objCockPit)
    {
        ideSourceEditor.setDesignCockpit(objCockPit);
    }

    public void read(Reader reader, Object o) throws IOException
    {
        ideSourceEditor.read(reader,o);
    }

    public void addCaretListener(CaretListener caretListener)
    {
        ideSourceEditor.addCaretListener(caretListener);
    }

    // return false if object is not within container.
    public boolean hasContainer()
    {
        return false;
    }
    // Return null if object does not have a Container else return container
    public Container getContainer()
    {
        return null;
    }
        // Return null if object has Container else return the Object
    public JComponent getTextEdit()
    {
        return ideSourceEditor;
    }

}

class IDESourceEditorImp extends org.comedia.ui.CSyntaxEditor {
    SuperDesignCockpit theCockpit;
    Hashtable actions;
    public IDEEditorPopupMenu thePopupMenu = null;

    public static final int UNDO_LIMIT = 1500;

    //UndoManager
    private UndoManager m_undoManager;

    public IDESourceEditorImp() {
        init();
    }

    public IDESourceEditorImp(SuperDesignCockpit objCockpit) {
        super();
        theCockpit = objCockpit;
        init();
    }

    private void init()
    {
        setSyntaxHighlighter(new CJavaHighlighter());
        createActionTable();
        //add the UndoableEditListener to the TextArea
        getDocument().addUndoableEditListener(this);
        createUndoMananger();

        assignExtraClipboardKeys();
        addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
                //System.out.println("Editor gained Focus");
                theCockpit.setLastFocussedComponent(IDESourceEditorImp.this);
            }

            public void focusLost(FocusEvent e) {
                //System.out.println("Editor lost Focus to " +e.getOppositeComponent());
                if (e.getOppositeComponent() instanceof JRootPane)
                    theCockpit.setLastFocussedComponent(IDESourceEditorImp.this);
                else
                    theCockpit.setLastFocussedComponent(null);

            }
        });
    }

    public void setDesignCockpit(SuperDesignCockpit objCockpit) {
        theCockpit = objCockpit;
    }
    /**
     * Assigns extra clipboard keys:
     * <UL>
     * <LI>Copy: Ctrl+Insert
     * <LI>Cut: Shift+Delete
     * <LI>Paste: Shift+Insert
     * </UL>
     * The standard Ctrl+C for Copy is still supported, etc
     */
    private void assignExtraClipboardKeys() {
        KeyStroke keyCopy = KeyStroke.getKeyStroke(KeyEvent.VK_INSERT, InputEvent.CTRL_MASK, false);
        KeyStroke keyPaste = KeyStroke.getKeyStroke(KeyEvent.VK_INSERT, InputEvent.SHIFT_MASK, false);
        KeyStroke keyCut = KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, InputEvent.SHIFT_MASK, false);
        Keymap map = getKeymap();
        map.addActionForKeyStroke(keyCopy, getActionByName("copy-to-clipboard"));
        map.addActionForKeyStroke(keyPaste, getActionByName("paste-from-clipboard"));
        map.addActionForKeyStroke(keyCut, getActionByName("cut-to-clipboard"));
    }

    /**
     * setCode - sets the code of the source viewer.
     *           This method sets the code, running it through the code formattter first.
     * @param sText
     */
    public Container getContainer()
    {
        return this;
    }
    void setCode(String sText) {
        StringReader theStringReader = new StringReader(sText);
        com.ibm.cf.CodeFormatter theFormatter = new com.ibm.cf.CodeFormatter();
        StringWriter theWriter = new StringWriter(sText.length());
        String sDelims = theCockpit.thePreferences.sDelimiters;
        String sStickyDelims = theCockpit.thePreferences.sStickyDelimiters;
        int iIndentation = theCockpit.thePreferences.iIndentation;
        int iMaxLineLength = theCockpit.thePreferences.iMaxLineLength;
        if (sDelims != null)
            theFormatter.setDelimiters(sDelims);
        if (sStickyDelims != null)
            theFormatter.setStickyDelimiters(sStickyDelims);
        theFormatter.setIndentationStep(iIndentation);
        if (iMaxLineLength != 0)
            theFormatter.setMaxLineLength(iMaxLineLength);
        theFormatter.formatCode(theStringReader, theWriter);
        theStringReader = new StringReader(theWriter.getBuffer().toString());
        try {
            read(theStringReader, null);
        } catch (java.io.IOException e1)
        {
            e1.printStackTrace();
        }
    }

    private void createActionTable() {
        actions = new Hashtable();
        Action[] actionsArray = getActions();
        for (int i = 0; i < actionsArray.length; i++) {
            Action a = actionsArray[i];
            String sActionName = (String) a.getValue(Action.NAME);

            //KeyStroke keyStroke = (KeyStroke) a.getValue(Action.ACCELERATOR_KEY);
            //String sKey = keyStroke != null ? keyStroke.toString() : "";
            //System.out.println(sActionName + " " +sKey);
            actions.put(sActionName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action) (actions.get(name));
    }

    //createUndoMananger creating undo manager
    private void createUndoMananger() {
        m_undoManager = new UndoManager();
        m_undoManager.setLimit(UNDO_LIMIT);
    }

    //undoableEditHappened called when edit happened
    public void undoableEditHappened(UndoableEditEvent e) {
        //add the edits to the unod manager
        m_undoManager.addEdit(e.getEdit());
    }

    public void undo() {
        try {
            //Undo changes
            m_undoManager.undo();
        } catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        try {
            //Redo changes
            m_undoManager.redo();
        } catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}
