/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JALabel;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: May 17, 2004
 * Time: 7:00:12 PM
 * To change this template use Options | File Templates.
 */
public class IDEProgressIndicator extends JADialog {
    private JALabel textArea = null;

    public IDEProgressIndicator (JAFrame owner, String title) {
        super(owner, title, false, false);

        Container pane = getContentPane();
        //setUndecorated(true);
        //getRootPane().setWindowDecorationStyle(JRootPane.PLAIN_DIALOG);
        textArea = new JALabel();
        textArea.setBorder(BorderFactory.createEmptyBorder(30,60,30,60));
        pane.add(textArea);
    }

    void displayMessage (String sMessage) {
        textArea.setText(sMessage);
        pack();
        setLocationRelativeTo(null);
    }

    public void show (Runnable runnable) {
        super.show(runnable);
        textArea.paintImmediately(0,0, textArea.getWidth(), textArea.getHeight());
    }

}
