/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;

/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class IDEMethodList extends JList {

    IDEMethodListModel theModel = null;
    String sPrevMethodNameSelected = null;
    public IDESourceEditor theSourceEditor = null;
    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theLastObjectLoaded = null;

    public IDEMethodList(IDEMethodListModel theListModel, SuperDesignCockpit objDesignCockpit) {
        super(theListModel);
        theDesignCockpit = objDesignCockpit;
        theModel = theListModel;
        setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        addListSelectionListener(new IDEMethodListSelectionListener(this));
        //addFocusListener(new IDEMethodListFocusListener(this));

    }

    public void Load(MetaClass someClass) {
        MetaObject theSelectedObject = theDesignCockpit.getDesignProject().getSelectedObject();

        // Don't allow complete erasures.
        if (theSourceEditor.getText().trim().length() != 0) {
            save();
        }

        theLastObjectLoaded = theSelectedObject;

        // Load the method list making sure it doesn't autosave.
        theModel.Load(theSelectedObject);
        setSelectedIndex(0);
        showCurrentMethod();
        updateUI();
    }

    public void resetContents() {
        theModel.theMetaObject = null;
        updateUI();
    }

    public void showMethodByName(String sMethodNameSelected) {
        MetaObject theSelectedObject = theDesignCockpit.getDesignProject().getSelectedObject();
        if ((sMethodNameSelected == null) || (theSelectedObject == null))
            return;
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;

        // Now we move to this method to get code to set.
        theMethod = theSelectedObject.theFirstMethod;
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
                theDesignCockpit.theSourceViewer.showCodeEditor();
                theSourceEditor.setCode(theMethod.theMethod.getCode());
                break;
            }
            theMethod = theMethod.theNextMethod;
        }
    }

    public void showCurrentMethod() {
        String sMethodNameSelected = (String) getSelectedValue();
        showMethodByName(sMethodNameSelected);
    }


    public boolean selectMethod(String sMethodName) {
        int iSelection = theModel.getValueIndex(sMethodName);
        if (iSelection != -1) {
            setSelectedIndex(iSelection);
            return true;
        } else
            return false;
    }

    public void save(String sMethodNameSelected) {
        MetaObject theSelectedObject = theLastObjectLoaded;
        if ((sMethodNameSelected == null) || (theSelectedObject == null))
            return;
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;
        String sOldCode = theSourceEditor.getText();
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
                if(theLastObjectLoaded!=theDesignCockpit.getSelectedObject())   // MHC
                    theMethod.theMethod.setCode(sOldCode);
                break;
            }
            theMethod = theMethod.theNextMethod;
        }
        // Allow new method to be added to object for last method edited.
        if ((theMethod == null) && (sOldCode != null) && (!sOldCode.trim().equals("")))
            theSelectedObject.setMethodCode(sPrevMethodNameSelected, sOldCode);
    }

    public void save() {
        String sMethodNameSelected = (String) getSelectedValue();
        save(sMethodNameSelected);
    }

    public void save(String sMethodNameSelected, String theCode) {
        MetaObject theSelectedObject = theLastObjectLoaded;
        if ((sMethodNameSelected == null) || (theSelectedObject == null))
            return;
        MetaMethodLinkage theMethod = theSelectedObject.theFirstMethod;
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodNameSelected)) {
                break;
            }
            theMethod = theMethod.theNextMethod;
        }
        theMethod.theMethod.setCode(theCode);
    }

}
