/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.event.ActionEvent;
import java.awt.*;
import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


class IDEArrayValueDescriptor {
    String sValue;

    public IDEArrayValueDescriptor(String sValue) {
        this.sValue = sValue;
    }
}

class IDEArrayValueEditorTableModel extends AbstractTableModel {

    MetaObject theMetaObject;
    ArrayList theArrayValues = new ArrayList(0);
    IDEArrayValueEditorTable theTable;
    String thePropertyName;
    int[] tabPageIndex;

    public void setArrayIndex(int row, int value) {
        tabPageIndex[row] = value;
        // Tell the table that it has changed.
        TableModelEvent event = new TableModelEvent(this, row, row);
        theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (theArrayValues == null)
            return 0;
        else
            return theArrayValues.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDEArrayValueDescriptor theDescriptor = (IDEArrayValueDescriptor) theArrayValues.get(row);
        if (theDescriptor != null) {
            if (column == 0) {  // object name
            } else {  //object title
                theDescriptor.sValue = (String) theNewValue;
            }
        }
    }

    public Object getValueAt(int row, int column) {
        IDEArrayValueDescriptor theDescriptor = (IDEArrayValueDescriptor) theArrayValues.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return new Integer(row);
            } else {
                return theDescriptor.sValue;
            }
        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0)
            return false;
        else
            return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0)
            return "Array Element";
        else
            return "Array Value";
    }

    protected void Load(IDEArrayValueEditorTable objTable, String thePropertyName) {
        this.thePropertyName = thePropertyName;
        theArrayValues = new ArrayList();
        if (theMetaObject != null) {
            int iCount = 0;
            MetaProperty theProp = theMetaObject.getPropertyMetadata(thePropertyName);
            if (theProp != null)
                iCount = theProp.getValueCount();
            for (int i = 0; i < iCount; i++) {
                MetaPropertyValueEx pvValue = theMetaObject.getPropertyValue(thePropertyName, i);
                String theValue = "";
                if (pvValue != null)
                    theValue = new String(pvValue.getStringValue());
                IDEArrayValueDescriptor theDescriptor = new IDEArrayValueDescriptor(theValue);
                theArrayValues.add(theDescriptor);
            }
        }
    }

    protected void clear() {
        theArrayValues = new ArrayList();
    }
}

class IDEArrayValueEditorTable extends JATable {

    public IDEArrayValueEditorTableModel theModel;
    public String thePropertyName;

    public IDEArrayValueEditorTable(IDEArrayValueEditorTableModel theTableModel, String thePropertyName) {
        super(theTableModel);
        theModel = theTableModel;
        this.thePropertyName = thePropertyName;
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        theModel.Load(this, thePropertyName);
        repaint();
    }

    public void resetContents() {
        theModel.clear();
        repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = getDefaultRenderer(theModel.getColumnClass(column));
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {

        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null)
            editor = getDefaultEditor(theModel.getColumnClass(column));
        return editor;
    }

}


public class IDEArrayValueEditor extends JADialog {

    String sPropertyName;
    MetaObject theObject;
    IDEArrayValueEditorTableModel theModel;
    IDEArrayValueEditorTable theArrayValueTable;
    JScrollPane theArrayValueScrollPane;
    UpButtonAction theUpAction;
    DownButtonAction theDownAction;
    DeleteButtonAction theDeleteAction;
    OKButtonAction theOKAction;
    InsertButtonAction theInsertAction;
    AppendButtonAction theAppendAction;
    CancelButtonAction theCancelAction;

    JButton theUpButton;
    JButton theDownButton;
    JButton theDeleteButton;
    JButton theOKButton;
    JButton theCancelButton;
    JButton theInsertButton;
    JButton theAppendButton;
    //AnchoringLayoutManager layoutManager = new AnchoringLayoutManager();
    SuperDesignCockpit theDesignCockpit;

    public IDEArrayValueEditor(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit) {
        super(theDesignCockpit, "Array Value Editor for " + sPropertyName, true, false);
        this.theObject = theObject;
        this.theDesignCockpit = theDesignCockpit;
        this.sPropertyName = sPropertyName;
        theModel = new IDEArrayValueEditorTableModel();
        theModel.theMetaObject = theObject;
        theArrayValueTable = new IDEArrayValueEditorTable(theModel, sPropertyName);
        theArrayValueScrollPane = new JScrollPane(theArrayValueTable);
        theArrayValueTable.Load();
        //setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);


        theUpAction = new UpButtonAction(this, theObject);
        theDownAction = new DownButtonAction(this, theObject);
        theDeleteAction = new DeleteButtonAction(this, theObject);
        theOKAction = new OKButtonAction(this, theObject);
        theCancelAction = new CancelButtonAction(this, theObject);
        theInsertAction = new InsertButtonAction(this, theObject);
        theAppendAction = new AppendButtonAction(this, theObject);

        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JAPanel pnlTable = new JAPanel(new FlowLayout());
        pnlTable.setLayout(new BorderLayout());
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        JAPanel pnlButtons = new JAPanel(new GridLayout(7,1, 10,10));

        pnlTable.add(theArrayValueScrollPane, BorderLayout.CENTER);

        theUpButton = new JButton(theUpAction);
        theDownButton = new JButton(theDownAction);
        theInsertButton = new JButton(theInsertAction);
        theDeleteButton = new JButton(theDeleteAction);
        theAppendButton = new JButton(theAppendAction);
        theOKButton = new JButton(theOKAction);
        theCancelButton = new JButton(theCancelAction);

        pnlButtons.add(theUpButton);
        pnlButtons.add(theDownButton);
        pnlButtons.add(theInsertButton);
        pnlButtons.add(theDeleteButton);
        pnlButtons.add(theAppendButton);
        pnlButtons.add(theOKButton);
        pnlButtons.add(theCancelButton);

        JAPanel pnlTopButtons = new JAPanel();
        pnlTopButtons.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        pnlTopButtons.add(pnlButtons);

        pane.add(pnlTable, BorderLayout.CENTER);
        pane.add(pnlTopButtons, BorderLayout.EAST);

        setSize(400, 300);
        setLocation(48, 120);

        setLocationRelativeTo(null);
        show(null);
    }

    void Load(String sPropertyName, MetaObject theObject) {
        setTitle("Array Value Editor for " + sPropertyName);
        this.theObject = theObject;
        this.sPropertyName = sPropertyName;
        theModel = new IDEArrayValueEditorTableModel();
        theModel.theMetaObject = theObject;
        theModel.thePropertyName = sPropertyName;
        theArrayValueTable.setModel(theModel);
        theArrayValueTable.Load();
    }

//    void place(JComponent comp, int x, int y, int cx, int cy, String sName) {
//        comp.setLocation(x, y);
//        comp.setSize(cx, cy);
//        if (sName != null) {
//            getContentPane().add(comp, sName);
//            layoutManager.setAnchoring(comp, true, false, true, false);
//        }
//    }

//    public void close() {
//        removeAll();
//        hide();
//    }

    class UpButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public UpButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Up");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow > 0) {
                Object objToRaise = theModel.theArrayValues.get(iRow);
                Object objToLower = theModel.theArrayValues.get(iRow - 1);
                theModel.theArrayValues.set(iRow, objToLower);
                theModel.theArrayValues.set(iRow - 1, objToRaise);
                theTable.repaint();
            }
            theEditor.theUpButton.setFocusPainted(false);
        }
    }

    class DownButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public DownButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Down");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            int iRowCount = theTable.getRowCount();
            if ((iRow != -1) && (iRow < (iRowCount - 1))) {
                Object objToRaise = theModel.theArrayValues.get(iRow + 1);
                Object objToLower = theModel.theArrayValues.get(iRow);
                theModel.theArrayValues.set(iRow + 1, objToLower);
                theModel.theArrayValues.set(iRow, objToRaise);
                theTable.repaint();
            }
            theEditor.theDownButton.setFocusPainted(false);
        }
    }

    class DeleteButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public DeleteButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Delete");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                theModel.theArrayValues.remove(iRow);
                theTable.updateUI();
            }
            theEditor.theDeleteButton.setSelected(false);
        }
    }

    class InsertButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public InsertButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Insert");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            int iRow = theTable.getSelectedRow();
            if (iRow != -1) {
                IDEArrayValueDescriptor newCellData = new IDEArrayValueDescriptor("");
                theModel.theArrayValues.add(iRow, newCellData);
                theTable.updateUI();
            }
            theEditor.theInsertButton.setSelected(false);
        }
    }

    class AppendButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public AppendButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Add");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            IDEArrayValueDescriptor newCellData = new IDEArrayValueDescriptor("");
            theModel.theArrayValues.add(newCellData);
            theTable.updateUI();
            theEditor.theAppendButton.setSelected(false);
        }
    }

    class OKButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public OKButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("OK");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEArrayValueEditorTable theTable = theEditor.theArrayValueTable;
//            IDEArrayValueEditorTableModel theModel = theEditor.theModel;
            int iValueCount = theTable.theModel.getRowCount();
            theEditor.theDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(theMetaObject, sPropertyName);
            for (int i = 0; i < iValueCount; i++) {
                theMetaObject.setPropertyValue(theEditor.sPropertyName, i, 0, theTable.theModel.getValueAt(i, 1), true);
            }
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }

    class CancelButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEArrayValueEditor theEditor = null;

        public CancelButtonAction(IDEArrayValueEditor theEditor, MetaObject theMetaObject) {
            super("Cancel");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }

}