/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import java.io.Writer;
import java.io.IOException;

/**
 * User: Stuart Booth
 * Date: Jul 27, 2004
 * Time: 11:04:46 AM
 */
class ExceptionWriter extends Writer {
    String sBuffer = "";
    protected Object lock;
    private SuperDesignCockpit theCockpit;

    protected ExceptionWriter (SuperDesignCockpit theCockpit) {
        this.theCockpit = theCockpit;
    }

    protected ExceptionWriter (SuperDesignCockpit theCockpit, Object lock) {
        this.theCockpit = theCockpit;
        this.lock = lock;
    }

    public String getBuffer () {
        return sBuffer;
    }

    public void close () throws IOException {
    }

    public void flush () throws IOException {
    }

    public void write (String str) throws IOException {
        sBuffer = sBuffer + str;
    }

    public void write (char[] cbuf) throws IOException {
        sBuffer = sBuffer + cbuf.toString();
    }

    public void write (int c) throws IOException {
        sBuffer = sBuffer + c;
    }

    public void write (String str, int off, int len) throws IOException {
        sBuffer = sBuffer + str.substring(off, len);
    }

    public void write (char[] cbuff, int off, int len) throws IOException {
        int i = off;
        while (i < (off + len))
            sBuffer = sBuffer + cbuff[i++];
    }
}
