/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart Booth (Live Clue, inc)
 * Date: Apr 4, 2005
 * Time: 8:52:18 PM
 */
public class DisplayMessage extends JADialog {
    private JATextArea m_txtMessage;
    private JAButton m_btnOk;

    public DisplayMessage(JAFrame jaFrame, String s) {
        super(jaFrame, s, true);
        setSize(600, 400);
        setLocationRelativeTo(jaFrame);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());
        m_txtMessage = new JATextArea();
        m_btnOk = new JAButton("OK");
        JAPanel pnlButtons = new JAPanel();
        pnlButtons.add(m_btnOk);
        contentPane.add(new JAScrollPane(m_txtMessage), BorderLayout.CENTER);
        contentPane.add(pnlButtons, BorderLayout.SOUTH);

        m_btnOk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                close();
            }
        });
    }

    public void showMessage (String sMessage) {
        m_txtMessage.setText(sMessage);
        m_txtMessage.setCaretPosition(0);
        show(new Runnable() {
            public void run() {
            }
        });
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top +=10; insets.left +=10; insets.right +=10;
        return insets;
    }
}
