/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.*;
import electric.xml.Element;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *
 *          <Name>text value that names project</Name>      <--- note that
 this should not have paths just the name
 <Author>text value that names the author</Author>
 <Version>version number of the project</Version>  <-- auto
 increments.
 <Hammer>version number of the hammer used to build it</Hammer>
 <- written by hammer.
 <AbaRenderer>minimum version of renderer required</AbaRenderer>  <--
 written by hammer - checked by renderer

 <Language>
 <Object Declarations>  Numerous

 *
 */

public class DesignProject {
    public SelectProjectAction theAssociatedAction;
    IDEUndoRedoController theUndoRedoController;
    MetaProject theMetaProject;
    MetaObject lastObjectSelected;
    MetaObject theSelectedFrame;         // The object that the view displayer has selected.
    ArrayList theSelectedObjects = new SelectedObjects(0);        // The current selected object.
    MetaObject theSelectedContainer;     // Where objects are added.
    DesignProject theNextDesignProject;
    DesignProject thePreviousDesignProject;
    private String sProjectDirectory;

    public DesignProject(MetaProject theMetaProject) {
        this.theMetaProject = theMetaProject;
        initializeUndoRedo();
    }

    public void initializeUndoRedo() {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
        theUndoRedoController = new IDEUndoRedoController(theDesignCockpit);
    }

    public IDEUndoRedoController getUndoRedoController() {
        return theUndoRedoController;
    }

    public int getInputType() {
        return theMetaProject.iInputType;
    }

    public void setInputType(int iInputType) {
        this.theMetaProject.iInputType = iInputType;
    }

    public MetaObject getFirstObject() {
        return theMetaProject.getFirstObject();
    }

    public MetaObject getLastObject() {
        return theMetaProject.getLastObject();
    }

    public void setFirstObject(MetaObject someObject) {
        theMetaProject.setFirstObject(someObject);
    }

    public void setLastObject(MetaObject someObject) {
        theMetaProject.setLastObject(someObject);
    }

    public MetaObject getLastObjectSelected() {
        return lastObjectSelected;      // previous object selected
    }

    public MetaObject getSelectedFrame() {
        return theSelectedFrame;
    }

    public void setSelectedFrame(MetaObject theSelectedFrame) {
        this.theSelectedFrame = theSelectedFrame;
    }

    public void setLastObjectSelected(MetaObject theLastObjectSelected) {
        this.lastObjectSelected = theLastObjectSelected;
    }

    public MetaObject getSelectedContainer() {
        return theSelectedContainer;
    }

    public void setSelectedContainer(MetaObject theSelectedContainer) {
        this.theSelectedContainer = theSelectedContainer;
    }

    public int getSelectedObjectCount() {
        if (theSelectedObjects == null)
            return 0;
        else
            return theSelectedObjects.size();
    }

    public MetaObject getSelectedObject(int iSelection) {
        if (theSelectedObjects == null)
            return null;
        if (iSelection >= theSelectedObjects.size())
            return null;
        // return last selected.
        return (MetaObject) theSelectedObjects.get(iSelection);
    }

    public MetaObject getSelectedObject() {
        if ((theSelectedObjects == null) || (theSelectedObjects.size() == 0))
            return null;
        // return last selected.
        return (MetaObject) theSelectedObjects.get(theSelectedObjects.size() - 1);
    }

    public void setSelectedObject(MetaObject theSelectedObject) {
        theSelectedObjects.add(theSelectedObject);
        if (theSelectedObject != null)
            theSelectedObject.bringForward();
    }

    public boolean isSelected(MetaObject theMetaObject) {
        return theSelectedObjects.contains(theMetaObject);
    }

    public void deselectObject(MetaObject theSelectedObject) {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
        theSelectedObjects.remove(theSelectedObject);
        theDesignCockpit.theSizeboxes.kill(theSelectedObject);
    }

    public void deselectObjects() {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
        theSelectedObjects.clear();
        if (theDesignCockpit.theSizeboxes != null)
            theDesignCockpit.theSizeboxes.kill();
    }

    public void dragSelected(MetaObject theMetaObject, Point ptViewDisplayerOrigin,
                             Point ptObjectOrigin, Point ptInObject, int left, int top) {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
        boolean bFound = false;
        for (int i = 0; i < theSelectedObjects.size(); i++) {
            MetaObject testObject = (MetaObject) theSelectedObjects.get(i);
            testObject.bAnchoringOff = true;
        }
        for (int i = 0; i < theSelectedObjects.size(); i++) {
            MetaObject testObject = (MetaObject) theSelectedObjects.get(i);
            if (testObject.equals(theMetaObject) == true)
                bFound = true;
            if ((testObject.isAbalet() == false) && (testObject.isFrame() == false) && (testObject.isJMenuSeparator() == false)
                        && (testObject.isJToolBarButton() == false) && (testObject.isJMenuItem() == false)
                            && (testObject.isJMenu() == false)) { // cannot drag these
                theDesignCockpit.doDragging(testObject, testObject.theVisualObject,
                        ptViewDisplayerOrigin, ptObjectOrigin, ptInObject, left, top);
            }
        }
        if (bFound == false) {
            theDesignCockpit.SelectObject(theMetaObject, true);
        }
    }

    public void setCurrentLanguage(int theLanguage) {
        theMetaProject.setCurrentLanguage(theLanguage);
    }

    public HammerLanguagePresentation getLanguage(int iLang) {
        return theMetaProject.getLanguage(iLang);
    }

    public MetaObject Pasting(MetaObject thePastedObject, SuperDesignCockpit theDesignCockpit) {
        // Fix up name if necessary - not to match another object.
        String sObjectName = thePastedObject.getName();
        if (findObject(sObjectName) != null) {
            sObjectName = getNewObjectName(thePastedObject.theType.theName);
            thePastedObject.setPropertyValue("Text", 0, 0, sObjectName, true);
        }
        thePastedObject.setName(sObjectName);
        MetaObject theNewObject = new MetaObject(thePastedObject,
                null, // No parent.
                theMetaProject,
                MetaObject.DESIGN_MODE); // This project.
        if (theNewObject != null) {
            addObject(theNewObject);
            theNewObject.create();
            // Tell the ObjectTreeView to add it.
            boolean bTest = theDesignCockpit.theViewDisplayer.testObject(theNewObject);
            if (bTest == true) {
                theDesignCockpit.SelectContainer(null);
                theDesignCockpit.theObjectTreeViewPane.addObjects(theNewObject);
//              theDesignCockpit.theViewDisplayer.displayObjects(theNewObject);
                theDesignCockpit.SelectContainer(theNewObject);
                return theNewObject;
            } else {
                theNewObject.DeleteObject(theMetaProject, theDesignCockpit);
                return null;
            }
        }
        return null;
    }

    // Paste the object as a child of this object.
    public MetaObject PasteChildObject(MetaObject thePastedObject, SuperDesignCockpit theCockpit, boolean bPreserveObjectNames) {
        MetaObject theNewObject = Pasting(thePastedObject, theCockpit);
        thePastedObject = thePastedObject.getFirstChild();
        while ((theNewObject != null) && (thePastedObject != null)) {
            if (theCockpit.PasteChildObject(theNewObject, thePastedObject, theMetaProject, bPreserveObjectNames) == null)
                return null;
            thePastedObject = thePastedObject.getNextObject();
        }
        return theNewObject;
    }


    /**
     * PasteObject
     * @param thePastedObject - the object to paste at the top of the project.
     * @return boolean - was it pasted?
     * Note:  There is no selected object.
     */

    public MetaObject PasteObject(MetaObject thePastedObject, SuperDesignCockpit theDesignCockpit, boolean bPreserveObjectNames) {
        MetaObject theNewObject = PasteChildObject(thePastedObject, theDesignCockpit, bPreserveObjectNames);
        if (theNewObject != null) {
            theDesignCockpit.SelectObject(theNewObject, false);
            return theNewObject;
        } else
            return null;
    }


    public MetaObject findObject(MetaObject theObject, String sObjectName) {
        while (theObject != null) {
            if (theObject.getName().equals(sObjectName))
                return theObject;
            MetaObject theChildMatch = findObject(theObject.theFirstChild, sObjectName);
            if (theChildMatch != null)
                return theChildMatch;
            theObject = theObject.theNextObject;
        }
        return null;
    }

    // MHC
    public ArrayList findObjectsByClass(String sClassName)
    {
        return theMetaProject.findObjectsByClass(sClassName);
    }

    public MetaObject findObject(String sObjectName) {
        return theMetaProject.findObject(sObjectName);
    }

    public String getNewObjectName(String sClassName) {
        return theMetaProject.getNewObjectName(sClassName);
    }


    public MetaClass findClass(MetaClass theClass, String sClassName) {
        return theMetaProject.findClass(theClass, sClassName);
    }

    public MetaClass findClass(String sClassName) {
        return theMetaProject.findClass(sClassName);
    }

    MetaClass findListener(MetaClass theListener, String sListenerName) {
        return theMetaProject.findListener(theListener, sListenerName);
    }

    MetaClass findListener(String sListenerName) {
        return theMetaProject.findListener(sListenerName);
    }

    public MetaClassDetail getNewListener(String sListenerName) {
        return theMetaProject.getNewListener(sListenerName);
    }

    public MetaClassDetail getNewDefaultListener(int iIndex) {
        return theMetaProject.getNewDefaultListener(iIndex);
    }

    public int getDefaultListenerCount() {
        return theMetaProject.getDefaultListenerCount();
    }

    public int getContainerListener() {
        return theMetaProject.getContainerListener();
    }

    public boolean findChildObjectByName(String sObjectName) {
        return theMetaProject.findChildObjectByName(sObjectName);
    }

    public boolean close (boolean vetoable) {
        int selection;
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) this.theMetaProject.getMetaDataUser();
        if (theMetaProject.getFirstObject() == null)
            return true;
        if (theMetaProject.getProjectChangedState() == false)
            return true;  // don't save projects that don't change.

        if (theDesignCockpit.isCustomizing() == false) {
            Object question = "Do you wish to save the project \"" + theMetaProject.sName + "\" before closing?";
            String title = "Close Confirmation Dialog";
            int optionType = JOptionPane.YES_NO_CANCEL_OPTION;
            if (vetoable == false)
                optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            selection = JOptionPane.showConfirmDialog(theDesignCockpit, question, title, optionType, messageType);
            if (selection == JOptionPane.CANCEL_OPTION)
                return false;
            if (selection == JOptionPane.NO_OPTION)
                return true;
            if ((theMetaProject.sName == null) || (theMetaProject.sName.startsWith("New Project")) || (theMetaProject.sName.trim().length() == 0))
                theDesignCockpit.theProjectName = null;
        }  else {
            selection = theDesignCockpit.theCustomizer.querySaveOnExit();
            if (selection == JOptionPane.CANCEL_OPTION)
                return false;
            if (selection == JOptionPane.NO_OPTION)
                return true;
        }
        theDesignCockpit.setCurrentDesignProject(this);
        theDesignCockpit.SaveProject(false); // save, but do not compile it
        return true;
    }

    public boolean store(boolean vetoable) {
        SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit) this.theMetaProject.getMetaDataUser();

        if (theMetaProject.getFirstObject() == null)
            return true;
        if (theMetaProject.getProjectChangedState() == false)
            return true;  // don't save projects that don't change.
        Object question = "Do you wish to save the project \"" + theMetaProject.sName + "\"?";
        String title = "Confirmation Dialog";
        int optionType = JOptionPane.YES_NO_CANCEL_OPTION;
        if (vetoable == false)
            optionType = JOptionPane.YES_NO_OPTION;
        int messageType = JOptionPane.QUESTION_MESSAGE;
        int selection = JOptionPane.showConfirmDialog(theDesignCockpit, question, title, optionType, messageType);
        if (selection == JOptionPane.CANCEL_OPTION)
            return false;
        if (selection == JOptionPane.NO_OPTION)
            return true;
        if ((theMetaProject.sName == null) || (theMetaProject.sName.startsWith("New Project")) || (theMetaProject.sName.trim().length() == 0))
            theDesignCockpit.theProjectName = null;
        theDesignCockpit.setCurrentDesignProject(this);
        theDesignCockpit.SaveProject(false);

        Component[] theProjectWindowMenuItems = theDesignCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
        for (int i = 0; i < theProjectWindowMenuItems.length; i++) {
            if (theProjectWindowMenuItems[i] instanceof JMenuItem) {
                JMenuItem theMenuItem = (JMenuItem) theProjectWindowMenuItems[i];
                if (theMenuItem.getText().equals(theMetaProject.sName)) {
                    theMenuItem.setText(theDesignCockpit.theProjectName);
                    break;
                }
            }
        }
        return true;
    }

    public boolean save(MetaProjectHeader progInfo, Element theParent) {
        return theMetaProject.save(progInfo, theParent);
    }


    public boolean load(Element theElement) {
        return theMetaProject.load(theElement);
    }

    public void addObject(MetaObject theNewObject) {
        theMetaProject.addObject(theNewObject);
    }


    public MetaConstantGroup findConstantGroup(String sGroupName) {
        return theMetaProject.findConstantGroup(sGroupName);
    }

    public MetaConstantGroupCollection findConstantGroupCollection(String sGroupName) {
        return theMetaProject.findConstantGroupCollection(sGroupName);
    }


    public boolean loadMeta(String sSystemDocument) {
        return theMetaProject.getMetadataDispenser().theMetadataDocument.loadMeta(sSystemDocument);
    }


    public boolean loadResource(String sResource) throws HammerException {
        return theMetaProject.loadResource(sResource);
    }

    public boolean loadXML(String sData) {
        return theMetaProject.loadXML(sData);
    }

    public boolean load(HammerJarAccess theJarAccess) {
        return theMetaProject.load(theJarAccess);
    }


    public boolean load(String sProjectDocument) {
        return theMetaProject.load(sProjectDocument);
    }


    public void setMetaDataUser(AbaMetaDataUser objUser) {
        theMetaProject.setMetaDataUser(objUser);
    }

    public AbaMetaDataUser getMetaDataUser() {
        return theMetaProject.getMetaDataUser();
    }

    public String getProjectDirectory() {
        return theMetaProject.getProjectDirectory();
    }

    public String getGenCodeLAF() {
        return theMetaProject.getGenCodeLAF();
    }

    public void setGenCodeLAF(String codeLAF) {
        theMetaProject.setGenCodeLAF(codeLAF);
    }

    public void setProjectDirectory(String sProjectDirectory) {
        theMetaProject.setProjectDirectory(sProjectDirectory);
    }

    private class SelectedObjects extends ArrayList {

        public SelectedObjects(int initialCapacity) {
            super(initialCapacity);
        }

        public boolean add(Object o) {
            //System.out.println("Add Object o");
            final boolean bAdd = super.add(o);
            SuperDesignCockpit cockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
            final IDEPropertyInspectorController propertyInspectorController = cockpit.getPropertyInspectorController();
            if (propertyInspectorController != null)
                propertyInspectorController.refreshPropertyInspector();
            return bAdd;
        }

//        public void add(int index, Object o) {
//            System.out.println("Add int index, Object o");
//            super.add(index, o);
//        }
//
//        public Object remove(int index) {
//            System.out.println("Remove int index");
//            return super.remove(index);
//        }

        public boolean remove(Object o) {
            //System.out.println("Remove Object o");
            final boolean bRemove = super.remove(o);
            SuperDesignCockpit cockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
            cockpit.getPropertyInspectorController().refreshPropertyInspector();
            return bRemove;
        }

        public void clear() {
            //System.out.println("Clear");
            super.clear();
            SuperDesignCockpit cockpit = (SuperDesignCockpit) theMetaProject.getMetaDataUser();
            cockpit.getPropertyInspectorController().refreshPropertyInspector();
        }

//        public boolean addAll(Collection collection) {
//            System.out.println("Add All collection");
//            return super.addAll(collection);
//        }
//
//        public boolean addAll(int index, Collection collection) {
//            System.out.println("AddAll int index collection");
//            return super.addAll(index, collection);
//        }
//
//        public void removeRange(int fromIndex, int toIndex) {
//            System.out.println("RemoveRange");
//            super.removeRange(fromIndex, toIndex);
//        }
    }
}
