/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class DesignPanel extends JLayeredPane {

    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theMetaObject = null;

    Color getAppropriateColor (Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256,
                (theColor.getGreen() + 128) % 256,
                (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public DesignPanel () {
        super();
//      this.setDoubleBuffered(true);
    }

    public DesignPanel (SuperDesignCockpit objDesignCockpit, MetaObject objMetaObject) {
        super();
        theDesignCockpit = objDesignCockpit;
        theMetaObject = objMetaObject;
//      this.setDoubleBuffered(true);
    }

    public Point getLocationOnScreen () {
        if (theMetaObject.isTabPage())
            return theMetaObject.theParentObject.theVisualObject.getLocationOnScreen();
        return super.getLocationOnScreen();
    }

    public void paintComponent (Graphics g) {
        float dash1[] = {1.0f, (float) theDesignCockpit.thePreferences.iViewDisplayerGridX - 1.0f};
        BasicStroke dashed = new BasicStroke(1.0f,
                BasicStroke.CAP_BUTT,
                BasicStroke.JOIN_MITER,
                1.0f, dash1, 0.0f);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension theSize = theMetaObject.getSize();
        Color theColor = theMetaObject.getBackgroundColor();

        if (theColor == null){
            //#ALEX, Small UI mod
           //theColor = new Color(160, 160, 160);
            theColor = SystemColor.control;
        }


        g2.setColor(theColor);
        g2.fillRect(0, 0, (int) theSize.getWidth(), (int) theSize.getHeight());

        // draw the grid...
        if (theDesignCockpit.thePreferences.bDisplayGrid) {
            Color thePenColor = getAppropriateColor(theColor);
            g2.setColor(thePenColor);
            int y = theDesignCockpit.thePreferences.iViewDisplayerGridY;
            int cx = (int) theSize.getWidth();
            int cy = (int) theSize.getHeight();
            g2.setStroke(dashed);
            while (y < cy) {
                g2.drawLine(0, y, cx - 1, y);
                y += theDesignCockpit.thePreferences.iViewDisplayerGridY;
            }
        }

        //#ALEX, Small UI mod, border
        g2.setColor (  SystemColor.controlShadow);
        g2.setStroke (new BasicStroke());
        g2.drawRect ( 0,0,(int) theSize.getWidth()-1, (int) theSize.getHeight()-1);

    }

/*
    public void paintComponent2(Graphics g) {
        Dimension theSize = getSize();
        if ((theDesignCockpit != null) && (theDesignCockpit.getDesignProject() != null) && (theDesignCockpit.getDesignProject().getSelectedFrame() != null)) {
            MetaObject theSelectedFrame = theDesignCockpit.getDesignProject().getSelectedFrame();
            // Use the frame or abalet for the view displayer always, even if a tabbed pane is selected.
            while ((theSelectedFrame != null) && (theSelectedFrame.isFrame() == false) && (theSelectedFrame.isAbalet() == false))
                theSelectedFrame = theSelectedFrame.theParentObject;
            Dimension theAbaletSize = theSelectedFrame.getSize();
            Color theColor = theSelectedFrame.getBackgroundColor();
            if (theColor == null)
                theColor = new Color(160, 160, 160);
            g.setColor(theColor);
            g.fillRect(0, 0, (int) theAbaletSize.getWidth() - 1, (int) theAbaletSize.getHeight() - 1);
            if (theSize.getWidth() - theAbaletSize.getWidth() > 0) {
                g.setColor(new Color(255, 255, 255));
                g.fillRect((int) theAbaletSize.getWidth(), 0,
                        (int) theSize.getWidth() - (int) theAbaletSize.getWidth(),
                        (int) theSize.getHeight());
            }
            if (theSize.getHeight() - theAbaletSize.getHeight() > 0) {
                g.setColor(new Color(255, 255, 255));
                g.fillRect(0, (int) theAbaletSize.getHeight(),
                        (int) theAbaletSize.getWidth(),
                        (int) theSize.getHeight() - (int) theAbaletSize.getHeight());
            }
            Color thePenColor = getAppropriateColor(theColor);
            g.setColor(thePenColor);
            int y = theDesignCockpit.theViewDisplayer.iAlignmentGridHeight;
            int x = theDesignCockpit.theViewDisplayer.iAlignmentGridWidth;
            int cx = (int) theSize.getWidth();
            int cy = (int) theSize.getHeight();
            while (y < cy) {
                g.drawLine(0, y, cx - 1, y);
                y += theDesignCockpit.theViewDisplayer.iAlignmentGridHeight;
            }
            while (x < cx) {
                g.drawLine(x, 0, x, cy - 1);
                x += theDesignCockpit.theViewDisplayer.iAlignmentGridWidth;
            }
        } else {
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, (int) theSize.getWidth() - 1, (int) theSize.getHeight() - 1);
        }
    }
*/


}
