/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.util.GlobalInterface;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerLNF;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Feb 4, 2004
 * Time: 12:13:08 PM
 * To change this template use Options | File Templates.
 */
public class DesignCockpit extends SuperDesignCockpit {

    public DesignCockpit(String sPreferences,
                         GlobalInterface theGlobalInterface) throws HammerException {
        super(sPreferences,
              theGlobalInterface,
              "ch.abacus.lib.ui.renderer.deploy.",
              "hammer-configuration.xml",
              "metadata.meta");
    }
    public DesignCockpit(String sPreferences,
                         GlobalInterface theGlobalInterface, String sproject) throws HammerException {
        super(sPreferences,
              theGlobalInterface,
              "ch.abacus.lib.ui.renderer.deploy.",
              "hammer-configuration.xml",
              "metadata.meta", sproject);
    }

    public static void main(String[] args) throws HammerException {
        // Change look & feel.

        DesignCockpit theDesignCockpit;

        String [] params = new String[3];
        for ( int iopt=0; iopt<args.length; iopt++ )
        {
            if ( args[iopt].equalsIgnoreCase("-p") )  // Project to load on startup (full path)
            {
                iopt++;
                if ( iopt<args.length )
                   params[2] = args[iopt];

            }
            else if ( args[iopt].equalsIgnoreCase("-c") )   // Preferences: Directory path (in quotes) containing default.conf
            {
                iopt++;
                if ( iopt<args.length )
                    params[0] = args[iopt];
            }
            else
            {
                params[0] = args[iopt];
            }
        }

        theDesignCockpit = new DesignCockpit(params[0], null, params[2]);

        // Set up program exit behavior.
        if (theDesignCockpit != null) {
            theDesignCockpit.defineInitialFrameListeners();
            theDesignCockpit.show();
        }

    }

}
