/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.UIFactoryCodeJumper;
import ch.abacus.lib.ui.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class CodeTesterPanel extends JAPanel {

    GridBagLayout theGridBag = null;
    GridBagConstraints cnstr = new GridBagConstraints();

    public CodeTesterPanel() {
        super();
        theGridBag = new GridBagLayout();
        setLayout(theGridBag);
    }

    public void add(Component cmp, int iColumn, int iRow, int iWidth, int iHeight) {
        GridBagConstraints cnstr = new GridBagConstraints();
        cnstr.fill = GridBagConstraints.BOTH;
        cnstr.gridx = iColumn;
        cnstr.gridy = iRow;
        cnstr.gridwidth = iWidth;
        cnstr.gridheight = iHeight;
        cnstr.weightx = 0.0;
        cnstr.weighty = 0.0;
        cnstr.insets = new Insets(5, 5, 5, 5);
        theGridBag.setConstraints(cmp, cnstr);
        add(cmp);
    }
}


public class CodeJumperTester extends JAFrame {
    SuperDesignCockpit theDesignCockpit;
    JATextField theLineNumber = new JATextField(30);
    JATextArea theMessage = new JATextArea(5, 30);
    JAButton theSubmitButton = new JAButton("Go!");

    public CodeJumperTester(SuperDesignCockpit objDesignCockpit) {
        setTitle("Code Jumper Tester");
        theDesignCockpit = objDesignCockpit;
        setSize(200, 250);
        JALabel thePromptText = new JALabel("Enter line number: ");
        Container theContainer = getContentPane();
        theContainer.setLayout(new BorderLayout());
        CodeTesterPanel thePanel = new CodeTesterPanel();
        thePanel.add(thePromptText, 0, 0, 1, 1);
        thePanel.add(theLineNumber, 0, 1, 1, 1);
        thePanel.add(theSubmitButton, 0, 3, 1, 1);
        thePanel.add(theMessage, 0, 5, 4, 5);
        theSubmitButton.addActionListener(new CodeJumperActionListener());
        theContainer.add(thePanel, BorderLayout.NORTH);
        setSize(240, 360);
        show();
    }


    class CodeJumperActionListener implements ActionListener {
        public CodeJumperActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String sMessage;
            int iLineNumber = (new Integer(theLineNumber.getText())).intValue();
            UIFactoryCodeJumper theCodeJumper = theDesignCockpit.theCodeJumper;
            int iJumpClass = theCodeJumper.getJumpPointClass(iLineNumber);
            int iJumpType = theCodeJumper.getJumpPointType(iLineNumber);
            String sClassName = theCodeJumper.getClassName(iLineNumber);
            String sListenerName = "";
            if (iJumpClass == UIFactoryCodeJumper.JUMPCLASS_LISTENER)
                sListenerName = theCodeJumper.getListenerName(iLineNumber);
            String sJumpPointDescription = "";
            switch (iJumpType) {
                case UIFactoryCodeJumper.JUMPPOINT_NONE:
                    sJumpPointDescription = "Error!";
                    break;
                case UIFactoryCodeJumper.JUMPPOINT_MEMBERDATA:
                    sJumpPointDescription = "Member Data: " + theCodeJumper.getMemberDataName(iLineNumber);
                    break;
                case UIFactoryCodeJumper.JUMPPOINT_METHOD:
                    sJumpPointDescription = "Method: " + theCodeJumper.getMethodName(iLineNumber);
                    break;
                case UIFactoryCodeJumper.JUMPPOINT_PROPERTY:
                    sJumpPointDescription = "Property: " + theCodeJumper.getPropertyName(iLineNumber);
                    break;
            }
            sMessage = "Class: " + sClassName + "\n";
            if (sListenerName.length() != 0)
                sMessage = sMessage + "Listener: " + sListenerName + "\n";
            sMessage = sMessage + sJumpPointDescription;
            theMessage.setText(sMessage);
        }
    }

}

