/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JACheckBox;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 11, 2003
 * Time: 6:58:43 PM
 * To change this template use Options | File Templates.
 */

class NLSDocumentListModel extends AbstractListModel {
    AbaNLS theNLSSupport;

    public NLSDocumentListModel(AbaNLS theNLSSupport) {
        this.theNLSSupport = theNLSSupport;
    }

    public Object getElementAt(int iIndex) {
        return theNLSSupport.getNLSDocumentByIndex(iIndex).getDocumentKey();
    }

    public int getSize() {
        return theNLSSupport.getDocumentCount();
    }

}


class NLSDocumentComboBoxModel extends NLSDocumentListModel implements ComboBoxModel {
    Object objSelection = null;
    Object objTarget = null;

    public NLSDocumentComboBoxModel(AbaNLS theNLSSupport, Object objTarget) {
        super(theNLSSupport);
        this.objTarget = objTarget;
    }

    public void setSelectedItem(Object theSelection) {
        objSelection = theSelection;
        try {
            Class cls = objTarget.getClass();
            Class[] parameterTypes = new Class[1];
            Object[] objParameters = new Object[1];
            objParameters[0] = theSelection;
            parameterTypes[0] = String.class;
            Method m = cls.getMethod("selectDocument", parameterTypes);
            m.invoke(objTarget, objParameters);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (SecurityException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (IllegalAccessException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (InvocationTargetException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        }
    }

    public Object getSelectedItem() {
        return objSelection;
    }

}


class NLSKeyListModel extends AbstractListModel {
    AbaNLS theNLSSupport;
    String sDocumentKey;
    ArrayList sKeys = new ArrayList(0);
    boolean bMnemonic = false;

    public NLSKeyListModel(AbaNLS theNLSSupport, boolean bMnemonic) {
        this.theNLSSupport = theNLSSupport;
        this.bMnemonic = bMnemonic;
    }

    public Object getElementAt(int iIndex) {
        return sKeys.get(iIndex);
    }

    public int getSize() {
        return sKeys.size();
    }

    public void selectDocument(String sDocumentKey) {
        if (sDocumentKey == null)
            return;
        sKeys.clear();
        this.sDocumentKey = new String(sDocumentKey);
        if (sDocumentKey.endsWith("_DE") || sDocumentKey.endsWith("_FR") ||
                sDocumentKey.endsWith("_EN") || sDocumentKey.endsWith("_IT")) {
            int iLength = sDocumentKey.length();
            this.sDocumentKey = sDocumentKey.substring(0, iLength - 3);
        }
        electric.xml.Element theRoot = theNLSSupport.getRootElement(sDocumentKey);
        if (theRoot != null) {
            electric.xml.Elements xmlTEXTs = theRoot.getElements("TEXT");
            String[] keys = new String[xmlTEXTs.size()];
            for (int i = 0; i < xmlTEXTs.size(); i++) {
                electric.xml.Element xmlTEXT = xmlTEXTs.next();
                String sKey = xmlTEXT.getAttribute("key");
                if (sKey != null)
                    keys[i] = sKey;
            }
            java.util.Arrays.sort(keys);
            for (int i=0 ; i<xmlTEXTs.size(); i++) {
                sKeys.add(keys[i]);
            }
        }

    }

}
class NLSKeyComboBoxModel extends NLSKeyListModel implements ComboBoxModel {
    Object objSelection;
    Object objTarget;

    public NLSKeyComboBoxModel(AbaNLS theNLSSupport, Object objTarget, boolean bMnemonic) {
        super(theNLSSupport, bMnemonic);
        this.objTarget = objTarget;
    }

    public void setSelectedItem(Object theSelection) {
        objSelection = theSelection;
        try {
            Class cls = objTarget.getClass();
            Class[] parameterTypes = new Class[1];
            Object[] objParameters = new Object[1];
            objParameters[0] = theSelection;
            parameterTypes[0] = String.class;
            Method m = cls.getMethod("selectKey", parameterTypes);
            m.invoke(objTarget, objParameters);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (SecurityException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (IllegalAccessException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (InvocationTargetException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        }
    }

    public Object getSelectedItem() {
        return objSelection;
    }
}

class NLSValueActionListener implements ActionListener {
    AbaNLSSelector theSelector;
    public NLSValueActionListener(AbaNLSSelector theSelector) {
        this.theSelector = theSelector;
    }
    public void actionPerformed(ActionEvent evt) {
        if (theSelector.btnChangeNLSOption.isSelected() == true) {
            if (theSelector.sPropertyName.equals("Mnemonic")) {
                if ((theSelector.txtValue.getText() != null) &&
                        (theSelector.txtValue.getText().length() == 1))
                    theSelector.btnOk.setEnabled(true);
                else
                    theSelector.btnOk.setEnabled(false);
            }
            else {
                if ((theSelector.txtValue.getText() != null) &&
                        (theSelector.txtValue.getText().length() > 0))
                    theSelector.btnOk.setEnabled(true);
                else
                    theSelector.btnOk.setEnabled(false);
            }
        }
    }
}

class NLSValueCheckFieldEntry extends JCheckBox {
    AbaNLSSelector theSelector;
    public NLSValueCheckFieldEntry(AbaNLSSelector theSelector) {
        super();
        this.theSelector = theSelector;
        this.addActionListener(new NLSValueActionListener(theSelector));
    }
}

public class AbaNLSSelector extends AbstractPropertyHelper {

    public AbaNLSSelector theProjectWrapper = this;
    protected JADialog dialog = null;
    protected JButton btnOk;
    protected JButton btnCancel;
    protected JComboBox cmbNlsDocuments = new JComboBox();
    protected JComboBox cmbNlsValueKeys = new JComboBox();
    protected NLSValueCheckFieldEntry btnChangeNLSOption = new NLSValueCheckFieldEntry(this);
    protected JACheckBox btnSetAllOption = new JACheckBox("Use Same NLS constant for all supported languages?", true);
    protected JTextField txtValue = new JTextField();
    protected JLabel JLabel1 = new JLabel();
    protected JLabel JLabel2 = new JLabel();
    protected JLabel JLabel3 = new JLabel();
    protected NLSDocumentComboBoxModel cmbmodelNlsDocuments;
    protected NLSKeyComboBoxModel cmbmodelNlsValueKeys;
    protected SuperDesignCockpit theDesignCockpit;
    protected OKButtonAction theOKAction;
    protected CancelButtonAction theCancelAction;
    protected MetaObject theObject;
    protected String sPropertyName;
    protected String sDocumentKey;  // abbreviated code for document.
    protected String sKeyName;
    protected Object refNotificationObject;
    static String lastDocumentKey;
    static final int FAKE_POSITION = -9999;
    static int lastXLocation = FAKE_POSITION;
    static int lastYLocation = FAKE_POSITION;
    boolean bMnemonic = false;
    int iIndex = -1;
    private boolean bChangesMade;

    public boolean execute(MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit) {
        dialog = new JADialog(superDesignCockpit, "AbaNLS Selector Tool" , true);
        this.theDesignCockpit = superDesignCockpit;
        this.sPropertyName = sPropertyName;
        if (sPropertyName.equals("Mnemonic"))
            bMnemonic = true;
        this.theObject = metaObject;
        this.iIndex = -1;
        try {
            initializeInterface();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bChangesMade;
    }

    public AbaNLSSelector() {
        super();
    }

    /**
     *
     * @param theObject
     * @param sPropertyName
     * @param iIndex
     * @param theDesignCockpit
     * @param refNotificationObject
     */
    public AbaNLSSelector(MetaObject theObject, String sPropertyName, int iIndex, SuperDesignCockpit theDesignCockpit, Object refNotificationObject) {
        dialog = new JADialog(theDesignCockpit, "AbaNLS Selector Tool" , true);
        this.theDesignCockpit = theDesignCockpit;
        this.sPropertyName = sPropertyName;
        if (sPropertyName.equals("Mnemonic"))
            bMnemonic = true;
        this.theObject = theObject;
        this.iIndex = iIndex;
        this.refNotificationObject = refNotificationObject;
        try {
            initializeInterface();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectDocument(String sDocumentKey) {
        if (sDocumentKey != null) {
            String sKeyName = this.sKeyName;
            cmbmodelNlsValueKeys.selectDocument(sDocumentKey);
            this.sDocumentKey = sDocumentKey;
            lastDocumentKey = new String(sDocumentKey);
            // reset the value keys (key should stay the same)
            this.cmbNlsValueKeys.setSelectedItem(null);
            this.cmbNlsValueKeys.setSelectedItem(sKeyName);
        }
    }

    public void selectKey(String sKeyName) {
        this.sKeyName = sKeyName;
        String sValue = this.theObject.theDesignProject.getNLS().getAbaNLSValue(sDocumentKey, sKeyName, bMnemonic);
        if ((sValue != null) && (sValue.equals(new String("\0")) == false)) {
            txtValue.setText(sValue);
            btnOk.setEnabled(true);
        }
        else {
            txtValue.setText("");
            btnOk.setEnabled(false);
        }
    }

    public void initializeFields(String sKey) {
        if (sKey.startsWith("@AbaNLS")) {
            int iFirstDot = sKey.indexOf(".");
            int iLastDot = sKey.lastIndexOf(".");
            // Exception processing - not enough dots.
            if ((iFirstDot == -1) || (iFirstDot == iLastDot))
                return;
            // Parse the pieces.
            String sDocumentKey = sKey.substring(iFirstDot + 1, iLastDot);
            String sSearchKey = sKey.substring(iLastDot + 1);
            // Add the language suffixes to the key.
            int iLanguagePresentation = theObject.theDesignProject.getCurrentLanguage().theLanguage;
            switch (iLanguagePresentation) {
                case HammerLanguagePresentation.DEUTSCH:
                    {
                        sDocumentKey = sDocumentKey + "_DE";
                        break;
                    }
                case HammerLanguagePresentation.FRANCAIS:
                    {
                        sDocumentKey = sDocumentKey + "_FR";
                        break;
                    }
                case HammerLanguagePresentation.ITALIAN:
                    {
                        sDocumentKey = sDocumentKey + "_IT";
                        break;
                    }
                case HammerLanguagePresentation.ENGLISH:
                    {
                        sDocumentKey = sDocumentKey + "_EN";
                        break;
                    }
                default:
                    {
                        sDocumentKey = sDocumentKey + "_DE";
                        break;
                    }
            }
//            cmbNlsDocuments.setSelectedItem(sDocumentKey);
//            cmbNlsValueKeys.setSelectedItem(sSearchKey);
            cmbmodelNlsDocuments.setSelectedItem(sDocumentKey);
            cmbmodelNlsValueKeys.setSelectedItem(sSearchKey);
//            selectDocument(sDocumentKey);
//            selectKey(sSearchKey);
        }

    }


    public void initializeInterface() {
        cmbmodelNlsValueKeys = new NLSKeyComboBoxModel(theObject.theDesignProject.getNLS(), this, bMnemonic);
        cmbmodelNlsDocuments = new NLSDocumentComboBoxModel(theObject.theDesignProject.getNLS(), this);
        // Make buttons
        theOKAction = new OKButtonAction(this, theObject);
        theCancelAction = new CancelButtonAction(this, theObject);
        btnOk = new JAButton(theOKAction);
        btnCancel = new JAButton(theCancelAction);
        //JFrame1.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        //  Get the content pane of the frame.
        JPanel contentPaneDialog = (JPanel) dialog.getContentPane();
        // Set the layout.
        AnchoringLayoutManager layoutManagerdialog = new AnchoringLayoutManager();
        contentPaneDialog.setLayout(layoutManagerdialog);
        dialog.setBackground(new Color(192, 192, 192));
        dialog.setForeground(new Color(0, 0, 0));
        if ((AbaNLSSelector.lastXLocation != FAKE_POSITION) &&
                (AbaNLSSelector.lastYLocation != FAKE_POSITION)) {
            dialog.setLocation(AbaNLSSelector.lastXLocation, AbaNLSSelector.lastYLocation);
        }
        else
            dialog.setLocation(new java.awt.Point(56, 192));
        dialog.setSize(new java.awt.Dimension(600, 354));
        Font font$$$btnOk = new Font("Arial", Font.PLAIN, 11);
        btnOk.setBackground(new Color(192, 192, 192));
        btnOk.setForeground(new Color(0, 0, 0));
        btnOk.setLocation(new java.awt.Point(480, 260));
        btnOk.setFont(font$$$btnOk);
        btnOk.setText("OK");
        btnOk.setSize(new Dimension(100, 22));
        btnOk.setEnabled(false);
        //  Add the control btnOk to the content pane.
        contentPaneDialog.add(btnOk, "btnOk");
        layoutManagerdialog.setAnchoring(btnOk, false, false, false, false);
        Font font$$$btnCancel = new Font("Arial", Font.PLAIN, 11);
        btnCancel.setBackground(new Color(192, 192, 192));
        btnCancel.setForeground(new Color(0, 0, 0));
        btnCancel.setLocation(new java.awt.Point(480, 288));
        btnCancel.setFont(font$$$btnCancel);
        btnCancel.setText("Cancel");
        btnCancel.setSize(100, 22);
        //  Add the control btnCancel to the content pane.
        contentPaneDialog.add(btnCancel, "btnCancel");
        layoutManagerdialog.setAnchoring(btnCancel, false, false, false, false);
        Font font$$$cmbNlsDocuments = new Font("Arial", Font.PLAIN, 11);
        cmbNlsDocuments.setBackground(new Color(255, 255, 255));
        cmbNlsDocuments.setForeground(new Color(0, 0, 0));
        cmbNlsDocuments.setLocation(new java.awt.Point(48, 36));
        cmbNlsDocuments.setSize(new java.awt.Dimension(144, 24));
        cmbNlsDocuments.setFont(font$$$cmbNlsDocuments);
        cmbNlsDocuments.setModel(cmbmodelNlsDocuments);
        //  Add the control cmbNlsDocuments to the content pane.
        contentPaneDialog.add(cmbNlsDocuments, "cmbNlsDocuments");
        layoutManagerdialog.setAnchoring(cmbNlsDocuments, false, false, false, false);
        Font font$$$cmbNLSValueKeys = new Font("Arial", Font.PLAIN, 11);
        cmbNlsValueKeys.setBackground(new Color(255, 255, 255));
        cmbNlsValueKeys.setForeground(new Color(0, 0, 0));
        cmbNlsValueKeys.setLocation(new java.awt.Point(232, 36));
        cmbNlsValueKeys.setSize(new java.awt.Dimension(216, 24));
        cmbNlsValueKeys.setFont(font$$$cmbNLSValueKeys);
        cmbNlsValueKeys.setModel(cmbmodelNlsValueKeys);
        cmbNlsValueKeys.setMaximumRowCount(20);
        //  Add the control cmbNLSValueKeys to the content pane.
        contentPaneDialog.add(cmbNlsValueKeys, "cmbNlsValueKeys");
        layoutManagerdialog.setAnchoring(cmbNlsValueKeys, false, false, false, false);

        Font font$$$btnSetAllOption = new Font("Arial", Font.PLAIN, 11);
        btnSetAllOption.setBackground(new Color(192, 192, 192));
        btnSetAllOption.setForeground(new Color(0, 0, 0));
        btnSetAllOption.setLocation(new java.awt.Point(40, 260));
        btnSetAllOption.setSize(new java.awt.Dimension(224, 22));
        btnSetAllOption.setFont(font$$$btnSetAllOption);
        //  Add the control btnChangeNLSOption to the content pane.
        contentPaneDialog.add(btnSetAllOption, "btnSetAllOption");
        layoutManagerdialog.setAnchoring(btnSetAllOption, false, false, false, false);

        Font font$$$btnChangeNLSOption = new Font("Arial", Font.PLAIN, 11);
        btnChangeNLSOption.setBackground(new Color(192, 192, 192));
        btnChangeNLSOption.setForeground(new Color(0, 0, 0));
        btnChangeNLSOption.setLocation(new java.awt.Point(40, 288));
        btnChangeNLSOption.setSize(new java.awt.Dimension(224, 22));
        btnChangeNLSOption.setFont(font$$$btnChangeNLSOption);
        btnChangeNLSOption.setText("Change NLS Document to new Value?");
        //  Add the control btnChangeNLSOption to the content pane.
        contentPaneDialog.add(btnChangeNLSOption, "btnChangeNLSOption");
        layoutManagerdialog.setAnchoring(btnChangeNLSOption, false, false, false, false);

        Font font$$$txtValue = new Font("Arial", Font.PLAIN, 11);
        txtValue.setBackground(new Color(255, 255, 255));
        txtValue.setForeground(new Color(0, 0, 0));
        txtValue.setLocation(new java.awt.Point(40, 226));
        txtValue.setSize(new java.awt.Dimension(220, 22));
        txtValue.setFont(font$$$txtValue);
        txtValue.setText("");
        //  Add the control txtValue to the content pane.
        contentPaneDialog.add(txtValue, "txtValue");
        layoutManagerdialog.setAnchoring(txtValue, false, false, false, false);
        Font font$$$JLabel1 = new Font("Arial", Font.PLAIN, 11);
        JLabel1.setBackground(new Color(192, 192, 192));
        JLabel1.setForeground(new Color(0, 0, 0));
        JLabel1.setLocation(new java.awt.Point(80, 10));
        JLabel1.setSize(new java.awt.Dimension(104, 16));
        JLabel1.setFont(font$$$JLabel1);
        JLabel1.setText("NLS Document");
        //  Add the control JLabel1 to the content pane.
        contentPaneDialog.add(JLabel1, "JLabel1");
        layoutManagerdialog.setAnchoring(JLabel1, false, false, false, false);
        Font font$$$JLabel2 = new Font("Arial", Font.PLAIN, 11);
        JLabel2.setBackground(new Color(192, 192, 192));
        JLabel2.setForeground(new Color(0, 0, 0));
        JLabel2.setLocation(new java.awt.Point(312, 10));
        JLabel2.setSize(new java.awt.Dimension(104, 16));
        JLabel2.setFont(font$$$JLabel2);
        JLabel2.setText("Value Key");
        //  Add the control JLabel2 to the content pane.
        contentPaneDialog.add(JLabel2, "JLabel2");
        layoutManagerdialog.setAnchoring(JLabel2, false, false, false, false);
        Font font$$$JLabel3 = new Font("Arial", Font.PLAIN, 11);
        JLabel3.setBackground(new Color(192, 192, 192));
        JLabel3.setForeground(new Color(0, 0, 0));
        JLabel3.setLocation(new java.awt.Point(92, 202));
        JLabel3.setSize(new java.awt.Dimension(104, 16));
        JLabel3.setFont(font$$$JLabel3);
        JLabel3.setText("Text Value of Field");
        //  Add the control JLabel3 to the content pane.
        contentPaneDialog.add(JLabel3, "JLabel3");
        layoutManagerdialog.setAnchoring(JLabel3, false, false, false, false);
        // Initialize values (if any)
        MetaPropertyValueEx pvPropValue = this.theObject.getPropertyValue(sPropertyName, 0);
        String sValue = "";
        if (pvPropValue != null)
            pvPropValue.getStringValue();

        if (lastDocumentKey != null) {
            this.cmbNlsDocuments.setSelectedItem(null);
            this.cmbNlsDocuments.setSelectedItem(lastDocumentKey);
        }

        initializeFields(sValue);
        // Show the main window
        dialog.show(null);
    }  // End of the initializeInterface method.

    class OKButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        AbaNLSSelector theEditor = null;

        public OKButtonAction(AbaNLSSelector theEditor, MetaObject theMetaObject) {
            super("OK");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
//            theMetaObject.theDesignProject.theUndoRedoController.createChangeDataLinkageEvent(theMetaObject);
            String sDocName = (String) theEditor.cmbNlsDocuments.getSelectedItem();
            if (sDocName.endsWith("_DE") || sDocName.endsWith("_FR") ||
                    sDocName.endsWith("_EN") || sDocName.endsWith("_IT"))
                sDocName = sDocName.substring(0, sDocName.length() - 3);
            String sNewTag = "@AbaNLS." + sDocName + "." +
                    theEditor.cmbNlsValueKeys.getSelectedItem();
            if (iIndex == -1)
                iIndex = 0;
            if (refNotificationObject != null) {
                Class[] clsParams = new Class[3];
                Object[] objParams = new Object[3];
                objParams[0] = sNewTag;
                clsParams[0] = sNewTag.getClass();
                objParams[1] = sPropertyName;
                clsParams[1] = sPropertyName.getClass();
                objParams[2] = new Integer(iIndex);
                clsParams[2] = objParams[2].getClass();
                Class refClass = refNotificationObject.getClass();
                try {
                    Method m = refClass.getMethod("newValueSelected", clsParams);
                    m.invoke(refNotificationObject, objParams);
                } catch (NoSuchMethodException e) {
                } catch (SecurityException e) {
                } catch (IllegalAccessException e) {
                } catch (IllegalArgumentException e) {
                } catch (InvocationTargetException e) {
                }
            } else {
                if (theEditor.btnSetAllOption.isSelected())
                    theMetaObject.setPropertyValue(sPropertyName, iIndex, 0, sNewTag, true);
                else
                    theMetaObject.setPropertyValue(sPropertyName, iIndex, 0, sNewTag, false);
                theDesignCockpit.getPropertyInspectorController().refreshPropertyInspector();
                if (theEditor.btnChangeNLSOption.isSelected()) {
                    // Change NLS file
                    if (theEditor.sPropertyName.equals("Mnemonic") == false)
                        theObject.theDesignProject.getNLS().changeAbaNLSValue(theEditor.sDocumentKey, theEditor.sKeyName, theEditor.txtValue.getText());
                    else
                        theObject.theDesignProject.getNLS().changeAbaNLSMnemonic(theEditor.sDocumentKey, theEditor.sKeyName, theEditor.txtValue.getText());
                }
                if (theEditor.sPropertyName.equals("Mnemonic") == false) {
                    MetaPropertyDescriptor theMnemonicMetadata = theMetaObject.theClass.getMetadata().getProperty("Mnemonic");
                    if (theMnemonicMetadata != null) { // is defined in class
                        MetaPropertyValueEx pvMnemonicSet = theMetaObject.getPropertyValue("Mnemonic", iIndex);
                        // Auto set to default.
                        if (pvMnemonicSet == null) { // is not defined in object
                            String sMnemonicValue = theObject.theDesignProject.getNLS().getAbaNLSValue(theEditor.sDocumentKey, theEditor.sKeyName, true);
                            if ((sMnemonicValue != null) && (sMnemonicValue.equals(new String("\0")) == false))
                                if (theEditor.btnSetAllOption.isSelected())
                                    theMetaObject.setPropertyValue("Mnemonic", iIndex, 0, sNewTag, true);
                                else
                                    theMetaObject.setPropertyValue("Mnemonic", iIndex, 0, sNewTag, false);
                        }
                    }
                }
                theEditor.theObject.refresh();
            }
            theEditor.savePosition();
            theEditor.dialog.removeAll();
            theEditor.dialog.hide();
            theEditor = null;
            bChangesMade = true;
        }
    }

    class CancelButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        AbaNLSSelector theEditor = null;

        public CancelButtonAction(AbaNLSSelector theEditor, MetaObject theMetaObject) {
            super("Cancel");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.savePosition();
            theEditor.dialog.removeAll();
            theEditor.dialog.hide();
            theEditor = null;
        }
    }

    private void savePosition() {
        Point ptFrame = dialog.getLocation();
        AbaNLSSelector.lastXLocation = ptFrame.x;
        AbaNLSSelector.lastYLocation = ptFrame.y;
    }


}
