/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Apr 27, 2004
 * Time: 12:33:20 PM
 */
package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.JATextField;
import ch.abacus.designcockpit.external.IDEFocusRequester;

import javax.swing.*;
import java.lang.reflect.Method;
import java.awt.event.KeyEvent;

public class LizardGeneralComboBoxEditorComponent extends JATextField {
    Object theReceiver = null;
    String sStoredValue = null;

    public LizardGeneralComboBoxEditorComponent(String value, int n, Object objReceiver) {
        super(value, n);
        theReceiver = objReceiver;
        addFocusListener(new LizardGeneralComboBoxEditorComponentFocusListener(this));
    }

    void processContentsChanged(Object objLosingFocus) {
        String sText = getText();
        if ((theReceiver != null) &&
                (((sStoredValue == null) && (sText.trim().length() != 0))
                || (!sText.equals(sStoredValue)))) {
            try {
                Class theClass = theReceiver.getClass();
                Class[] clsList = new Class[2];
                clsList[0] = sText.getClass();
                clsList[1] = Class.forName("java.lang.Object");
                Method m = theClass.getMethod("getExitingComboBox", clsList);
                Object[] objList = new Object[2];
                objList[0] = sText;
                objList[1] = objLosingFocus;
                Boolean oReturnValue = (Boolean) m.invoke(theReceiver, objList);
                if (oReturnValue.booleanValue() == false) {
                    IDEFocusRequester.requestFocus((JComponent)this);
                    // otherwise nothing gets the focus.
                    return;
                }
            } catch (ClassNotFoundException e0) {
            } catch (NoSuchMethodException e1) {
                System.out.println("General ComboBox Error: Receiver has no implementation!");
            } catch (java.lang.reflect.InvocationTargetException e2) {
                System.out.println("General ComboBox Error: Bad Target Receiver!");
            } catch (IllegalAccessException e3) {
                System.out.println("General ComboBox Error: Illegal Access!");
            }
        }
        sStoredValue = sText;
    }

    void processPrompt(Object objLosingFocus) {
        String sText = getText();
        if ((theReceiver != null) &&
                (((sStoredValue == null) && (sText.trim().length() != 0))
                || (!sText.equals(sStoredValue)))) {
            try {
                Class theClass = theReceiver.getClass();
                Class[] clsList = new Class[2];
                clsList[0] = sText.getClass();
                clsList[1] = Class.forName("java.lang.Object");
                Method m = theClass.getMethod("getPromptForComboBox", clsList);
                Object[] objList = new Object[2];
                objList[0] = sText;
                objList[1] = objLosingFocus;
                Boolean oReturnValue = (Boolean) m.invoke(theReceiver, objList);
                if (oReturnValue.booleanValue() == false) {
                    IDEFocusRequester.requestFocus((JComponent)this);
                    // otherwise nothing gets the focus.
                    return;
                }
            } catch (ClassNotFoundException e0) {
            } catch (NoSuchMethodException e1) {
                System.out.println("General ComboBox Error: Receiver has no implementation!");
            } catch (java.lang.reflect.InvocationTargetException e2) {
                System.out.println("General ComboBox Error: Bad Target Receiver!");
            } catch (IllegalAccessException e3) {
                System.out.println("General ComboBox Error: Illegal Access!");
            }
        }
        sStoredValue = sText;
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_TAB)
            processContentsChanged(this);
        else if (e.getKeyCode() != KeyEvent.VK_F4)
            super.processKeyEvent(e);
        else
            processPrompt(this);

//        if ((e.getKeyCode() == KeyEvent.VK_TAB) || (e.getKeyChar() == '\t') ||
//            (e.getKeyCode() == KeyEvent.VK_ENTER))
    }

}