/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;


import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;


public class Lizard extends JAFrame {
    MetaClass theMetaClass = null;
    LizardMetadataOpenAction metadataOpenAction = null;
    LizardMetadataSaveAction metadataSaveAction = null;
    LizardNewClassAction newClassAction = null;
    MetadataDispenser theMetadataDispenser;

    public LizardClassDetailViewer theViewerTabs = null;

    public Lizard(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser,SuperDesignCockpit theCockpit) {
        setTitle("Component Class Edit Tool");
        setSize(550, 450);
        setResizable(false);

        Container jParContainer = theCockpit;
        Dimension dm = jParContainer.getSize();
        Double wLoc = new Double((dm.getWidth()/2)  - this.getWidth()/2);
        Double hLoc = new Double((dm.getHeight()/2) -  this.getHeight()/2);


        setLocation(wLoc.intValue(), hLoc.intValue());

        theMetaClass = objMetaClass;
        this.theMetadataDispenser = theMetadataDispenser;

        // Add the Tab Pane for Member Data, Methods, Properties, and Constructors.
        theViewerTabs = new LizardClassDetailViewer(theMetaClass, theMetadataDispenser,theCockpit);
        getContentPane().add(theViewerTabs);
        show();
        theViewerTabs.updateUI();
    }
}


