/**
 * FontChooserBean.java  1.00 97/08/09 Merlin Hughes
 *
 * Copyright (c) 1997 Merlin Hughes, All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for commercial and non-commercial purposes and without fee is
 * hereby granted provided that this copyright notice appears in
 * all copies.
 *
 * http://prominence.com/                         ego@merlin.org
 */

package org.merlin.beans.font;

import java.awt.*;
import java.beans.*;
import java.awt.event.*;

import org.merlin.beans.numberfield.*;

public class FontChooserBean extends Container implements PropertyChangeListener, ItemListener {
  protected Font oFont = new Font ("Serif", Font.PLAIN, 10);
  protected Choice name;
  protected Checkbox bold, italic;
  protected NumberFieldBean size;

  public FontChooserBean () {
    setLayout (new GridLayout (2, 2));
    add (name = new Choice ());
    String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    for (int i = 0; i < fonts.length; ++ i)
      name.addItem (fonts[i]);
    name.select (oFont.getName ());
    name.addItemListener (this);
    try {
      size = (NumberFieldBean) Beans.instantiate (getClass ().getClassLoader (), "org.merlin.beans.numberfield.NumberFieldBean");
    } catch (Exception ex) {
      ex.printStackTrace ();
    }
    add ((Component) Beans.getInstanceOf (size, Component.class));
    size.setColumns (3);
    size.setValue (oFont.getSize ());
    size.setMinimum (1);
    size.setMaximum (128);
    size.setStep (1);
    size.addPropertyChangeListener (this);
    add (bold = new Checkbox ("bold"));
    bold.setState (oFont.isBold ());
    bold.setFont (new Font ("TimesRoman", Font.BOLD, 12));
    bold.addItemListener (this);
    add (italic = new Checkbox ("italic"));
    italic.setState (oFont.isBold ());
    italic.setFont (new Font ("TimesRoman", Font.ITALIC, 12));
    italic.addItemListener (this);
  }

  protected boolean suppressEvents;

  public void setStyle (Font f) {
    suppressEvents = true;
    name.select (f.getName ());
    bold.setState (f.isBold ());
    italic.setState (f.isItalic ());
    size.setValue (f.getSize ());
    suppressEvents = false;
    fireStateChange ();
  }

  public Font getStyle () {
    return new Font (name.getSelectedItem (), 0 |
                     (bold.getState () ? Font.BOLD : 0) |
                     (italic.getState () ? Font.ITALIC : 0),
                     size.getValue ());
  }

  public void itemStateChanged (ItemEvent e) {
    fireStateChange ();
  }

  public void propertyChange (PropertyChangeEvent e) {
    fireStateChange ();
  }

  protected PropertyChangeSupport listeners =
    new PropertyChangeSupport (this);

  public void addPropertyChangeListener (PropertyChangeListener l) {
    listeners.addPropertyChangeListener (l);
  }

  public void removePropertyChangeListener (PropertyChangeListener l) {
    listeners.removePropertyChangeListener (l);
  }

  protected void fireStateChange () {
    if (!suppressEvents)
      listeners.firePropertyChange ("style", oFont, oFont = getStyle ());
  }
}
