/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.layout;

import java.awt.*;
import java.awt.event.*;

/**
 * Implements a simple layout manager which place all controls at the
 * center of the container one by one.
 */
public class CCentralLayout implements LayoutManager, java.io.Serializable {

  /**
   * Constructs this layout manager with default properties.
   */
  public CCentralLayout() {
  }

  /**
   * Adds a new component to this layout.
   * @paran name a name of added component.
   * @param component an added component object.
   */
  public void addLayoutComponent(String name, Component component) {
  }

  /**
   * Removes a component from this layout.
   * @param component a deleted component object.
   */
  public void removeLayoutComponent(Component component) {
  }

  /**
   * Gets a preferred component size for this layout.
   * @param container a components container.
   * @result a preferred size for components.
   */
  public Dimension preferredLayoutSize(Container parent) {
    return (new Dimension(100, 50));
  }

  /**
   * Gets a minimum component size for this layout.
   * @param container a components container.
   * @result a minimum size for components.
   */
  public Dimension minimumLayoutSize(Container parent) {
    return (new Dimension(20, 20));
  }

  /**
   * Performs a layout of current component in the container.
   * @param parent a components container to perform a layout.
   */
  public void layoutContainer(Container parent) {
    Component[] components = parent .getComponents();
    Dimension frame = parent.getSize();
    Insets b = parent.getInsets();
    for (int i = 0; i < components.length; i++) {
      components[i].setSize(components[i].getPreferredSize());
      Dimension d = components[i].getSize();
      components[i].setLocation(
        b.left+(frame.width-d.width-b.left-b.right)/2,
        b.top+(frame.height-d.height-b.top-b.bottom)/2
      );
    }
  }
}