/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @(#) LinearCongruence.java     1.0 04.11.2002 10:18:37 Pecar
 *
 * Copyright (c) 2002 ABACUS Research AG, All Rights Reserved
 *
 */

package ch.abacus.lib.util.math;

public class LinearCongruence {
  private int current;

  private int b;
  private int m;

  /**
   *
   * @param seed
   * @param b should not be too big and not too small like ...x21 where x is even
   * @param m should be as big as possible but smaller than Integer.MAX_VALUE / 2
   */
  public LinearCongruence(int seed, int b, int m) {
    current = seed;
    this.b = b;
    if(m >= Integer.MAX_VALUE / 2)
      throw new RuntimeException("m is too big");
    this.m = m;
  }

  public LinearCongruence(int seed) {
    this(seed, 31415821, 100000000);
  }

  /**
   * this is just to show the principle
   * @return
   */
  public int nextSimple() {
    current = (current * b + 1) % m;
    return current;
  }

  public int next() {
    current = (mult(current, b) + 1) % m;
    return current;
  }

  private static final int MULT_HELP = 10000;
  public final int mult(int p, int q) {
    int p1 = p / MULT_HELP;
    int p0 = p % MULT_HELP;
    int q1 = q / MULT_HELP;
    int q0 = q % MULT_HELP;
    int t =((p0 * q1 + p1 * q0) % MULT_HELP) * MULT_HELP + p0 * q0;
    return t;
  }

  private static final LinearCongruence LC = new LinearCongruence((int) System.currentTimeMillis());
  public static final int random() {
    synchronized(LC) {
      return LC.next();
    }
  }
}
