/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer;
import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;
import ch.abacus.lib.util.GlobalInterface;

import javax.swing.border.Border;
import java.awt.*;
import java.util.ArrayList;
import java.util.Vector;
import java.util.HashMap;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 22.11.2003
 * Time: 09:11:10
 * To change this template use Options | File Templates.
 */
public class MetadataDispenser {

    public MetaProject thePrototypeProject;
    private MetaClass theDefaultPanelClass;
    private GlobalInterface theGlobalInterface;

    public MetaClass getFirstClass() {
        return theFirstClass;
    }

    public void setFirstClass(MetaClass theFirstClass) {
        this.theFirstClass = theFirstClass;
    }

    public MetaClass getLastClass() {
        return theLastClass;
    }

    public void setLastClass(MetaClass theLastClass) {
        this.theLastClass = theLastClass;
    }

    public MetaClass getFirstListener() {
        return theFirstListener;
    }

    public void setFirstListener(MetaClass theFirstListener) {
        this.theFirstListener = theFirstListener;
    }

    public MetaClass getLastListener() {
        return theLastListener;
    }

    public void setLastListener(MetaClass theLastListener) {
        this.theLastListener = theLastListener;
    }

    public int getiListenerCount() {
        return iListenerCount;
    }

    public void setiListenerCount(int iListenerCount) {
        this.iListenerCount = iListenerCount;
    }

    public MetaConstantGroup getFirstMetaConstantGroup() {
        return theFirstMetaConstantGroup;
    }

    public void setFirstMetaConstantGroup(MetaConstantGroup theFirstMetaConstantGroup) {
        this.theFirstMetaConstantGroup = theFirstMetaConstantGroup;
    }

    public MetaConstantGroup getLastMetaConstantGroup() {
        return theLastMetaConstantGroup;
    }

    public void setLastMetaConstantGroup(MetaConstantGroup theLastMetaConstantGroup) {
        this.theLastMetaConstantGroup = theLastMetaConstantGroup;
    }

    public MetaConstantGroupCollection getFirstMetaConstantGroupCollection() {
        return theFirstMetaConstantGroupCollection;
    }

    public void setFirstMetaConstantGroupCollection(MetaConstantGroupCollection theFirstMetaConstantGroupCollection) {
        this.theFirstMetaConstantGroupCollection = theFirstMetaConstantGroupCollection;
    }

    public MetaConstantGroupCollection getLastMetaConstantGroupCollection() {
        return theLastMetaConstantGroupCollection;
    }

    public void setLastMetaConstantGroupCollection(MetaConstantGroupCollection theLastMetaConstantGroupCollection) {
        this.theLastMetaConstantGroupCollection = theLastMetaConstantGroupCollection;
    }

    public ListenerCollection getListenerCollection() {
        return theListenerCollection;
    }

    public void setListenerCollection(ListenerCollection theListenerCollection) {
        this.theListenerCollection = theListenerCollection;
    }

    MetaClass theFirstClass;
    MetaClass theLastClass;
    MetaClass theFirstListener;
    MetaClass theLastListener;
    MetaClass theVerticalSplitterClass;
    MetaClass theHorizontalSplitterClass;

    int iListenerCount = 0;
    MetaConstantGroup theFirstMetaConstantGroup = null;
    MetaConstantGroup theLastMetaConstantGroup = null;
    MetaConstantGroupCollection theFirstMetaConstantGroupCollection = null;
    MetaConstantGroupCollection theLastMetaConstantGroupCollection = null;
    ListenerCollection theListenerCollection;
    public MetadataAdministrator theMetaDataAdministrator; // Changes to metadata
    public HammerMetadataDocument theMetadataDocument = new HammerMetadataDocument(this);
    public int iMetadataVersion = 0;
    public int iMetadataRevision = 0;
    public int iMetadataSubrevision = 0;
    public int iMetadataBuild = 0;
    public String sDesignBorderDefinition = "construct:javax.swing.border.LineBorder[Color=clColGroupBorder,int=2,boolean=false]";
    public int iMode = MetaObject.DESIGN_MODE;
    public AbaMetaDataUser theUser;
    public ArrayList objSubscribers = new ArrayList();
    private static HashMap ClassTracker = null;

    public MetadataDispenser(AbaMetaDataUser theUser, GlobalInterface theGlobalInterface, int iMode) throws HammerException {
        this.iMode = iMode;
        this.theUser = theUser;
        this.theGlobalInterface = theGlobalInterface;
        if (iMode == MetaObject.DESIGN_MODE)
            theListenerCollection = new ListenerCollection();
        thePrototypeProject = new MetaProject(iMode, theGlobalInterface, theUser.getClassLoader(), this);
        ClassTracker = new HashMap();
    }

    public AbaMetaDataUser getMetadataUser() {
        return theUser;
    }

    public MetaProject getPrototypeProject() {
        return thePrototypeProject;
    }

    public void setListenerCount(int iListenerCount) {
        this.iListenerCount = iListenerCount;
    }

    public MetaClass findClass(DropletSimpleLog theLog, MetaClass theClass, String sClassName) {
        // Navigate through children.

        if(ClassTracker.containsKey(sClassName))
        {
            MetaClass rtClass = (MetaClass)ClassTracker.get(sClassName);
            if (theLog!=null)
                theLog.writeMessage("class found in Dispenser cache: " + theClass.theMetadata.sClassName);
            return rtClass;
        }

        while (theClass != null) {
            if (theLog!=null)
                theLog.writeMessage("Test class with class name: " + theClass.theMetadata.sClassName);
            if (theClass.theMetadata.sClassName.equals(sClassName))
            {
                ClassTracker.put(sClassName,theClass);
                return theClass;
            }
            if (theClass.theFirstClass != null) {
                MetaClass testClass = findClass(theLog, theClass.theFirstClass, sClassName);
                if (testClass != null)
                    return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass findClass(MetaClass theClass, String sClassName) {
        return findClass((DropletSimpleLog) null, theClass, sClassName);
    }

    public MetaClass findClass(DropletSimpleLog theLog, String sClassName) {
        MetaClass theClass = theFirstClass;
        if (theLog!=null)
            theLog.writeMessage("Searching for class: " + sClassName);
        if (theLog!=null) {
            if (theClass == null)
                theLog.writeMessage("No classes in metadata");
            else
                theLog.writeMessage("First class: " + theClass.getMetadata().sFullClassName);
        }
        while (theClass != null) {
            if (theLog!=null)
                theLog.writeMessage("Test class with class name: " + theClass.theMetadata.sClassName);
            if (theClass.theMetadata.sClassName.equals(sClassName))
                return theClass;
            if (theClass.theFirstClass != null) {
                MetaClass testClass = findClass(theLog, theClass.theFirstClass, sClassName);
                if (testClass != null)
                    return testClass;
            }
            theClass = theClass.theNextSibling;
        }
        return null;
    }

    public MetaClass findClass(String sClassName) {
        return findClass((DropletSimpleLog) null, sClassName);
    }

    // Return the available MetaClasses
    public Vector getMetaClassesList( MetaClass theClass ) {
        Vector vClassList = new Vector();

        if (theClass.getFirstClass() != null) {

            MetaClass theSubMetaClass = theClass.getFirstClass();
            while (theSubMetaClass != null && theSubMetaClass.theFirstClass!=null) {
                vClassList.add(theSubMetaClass.theMetadata.sClassName);
                theSubMetaClass = theSubMetaClass.getNextSibling();
            }
        }

        return vClassList;
    }
    public Vector getMetaClassesList() {
        return getMetaClassesList(theFirstClass);
    }

    public MetaClass findListener(MetaClass theListener, String sListenerName) {
        // Navigate through children.
        while (theListener != null) {
            if (theListener.theMetadata.sClassName.equals(sListenerName))
                return theListener;
            if (theListener.theFirstClass != null) {
                MetaClass testListener = findListener(theListener.theFirstClass, sListenerName);
                if (testListener != null)
                    return testListener;
            }
            theListener = theListener.theNextSibling;
        }
        return null;
    }

    public MetaClass findListener(String sListenerName) {
        MetaClass theListener = theFirstListener;
        while (theListener != null) {
            if (theListener.theMetadata.sClassName.equals(sListenerName))
                return theListener;
            int iLastIndexOf = theListener.theMetadata.sClassName.lastIndexOf(".");
            if (iLastIndexOf != -1) {
                String sSimpleName = theListener.theMetadata.sClassName.substring(iLastIndexOf + 1);
                if (sSimpleName.equals(sListenerName))
                    return theListener;
            }
            if (theListener.theFirstClass != null) {
                MetaClass testListener = findListener(theListener.theFirstClass, sListenerName);
                if (testListener != null)
                    return testListener;
            }
            theListener = theListener.theNextSibling;
        }
        return null;
    }

    public MetaClassDetail getNewListener(String sListenerName) {
        MetaClass matchingListener = findListener(sListenerName);
        if (matchingListener != null) {
            MetaClassDetail theNewMetadata = new MetaClassDetail(matchingListener.theMetadata, this);
            return theNewMetadata;
        }
        return null;
    }

    public MetaClassDetail getNewDefaultListener(int iIndex) {
        if (theListenerCollection == null) {
            return null;
        }
        MetaClassDetail theListenerMetadata = theListenerCollection.getDefaultListenerClassMetadata(iIndex);
        if (theListenerMetadata != null) {
            MetaClassDetail theNewMetadata = new MetaClassDetail(theListenerMetadata, this);
            theNewMetadata.sClassName = theListenerCollection.getDefaultListenerName(iIndex);
            return theNewMetadata;
        }
        return null;
    }

    public int getDefaultListenerCount() {
        if (theListenerCollection == null)
            return 0;
        else
            return theListenerCollection.iDefaultListeners;
    }

    public int getContainerListener() {
        if (theListenerCollection == null) {
            return 0;
        }
        return theListenerCollection.getContainerListener();
    }

    public MetaClass addClass(electric.xml.Element theClassDescriptor) {
        return theMetadataDocument.loadClass(theClassDescriptor, null);
    }

    public void addClass(MetaClass newChild) {
        newChild.theParentClass = null;
        if (theLastClass == null)
            theFirstClass = newChild;
        else {
            newChild.thePrevSibling = theLastClass;
            theLastClass.theNextSibling = newChild;
        }
        theLastClass = newChild;
    }

    public int getListenerCount() {
        if (theListenerCollection == null) {
            return 0;
        }
        return this.theListenerCollection.iListenerCount;
    }

    public MetaConstantGroup findConstantGroup(String sGroupName) {
        MetaConstantGroup testGroup = theFirstMetaConstantGroup;
        while (testGroup != null) {
            if (testGroup.sClassName.equals(sGroupName))
                return testGroup;
            testGroup = testGroup.theNextSibling;
        }
        return null;
    }

    public MetaConstantGroupCollection findConstantGroupCollection(String sGroupName) {
        if(sGroupName==null)
            return null;
        MetaConstantGroupCollection testGroup = theFirstMetaConstantGroupCollection;
        while (testGroup != null) {
            if (testGroup.sClassName.equals(sGroupName))
                return testGroup;
            testGroup = testGroup.theNextSibling;
        }
        return null;
    }

    public Border getDesignBorder(AbaMetaDataUser theMetaDataUser) {
        Object obj = null;
        try {
            obj = MetaConstantGroup.resolve(this.sDesignBorderDefinition, this, theMetaDataUser.getClassLoader().getLoader());
        } catch (HammerException e) {
            return new javax.swing.border.LineBorder(Color.BLUE);
        }
        if (obj instanceof Border)
            return (Border) obj;
        else
            return new javax.swing.border.LineBorder(Color.BLUE);
    }

    public MetaClass getHorizontalSplitterClass() {
        return theHorizontalSplitterClass;
    }

    public MetaClass getVerticalSplitterClass() {
        return theVerticalSplitterClass;
    }

    public void remove(AbaRenderer abaRenderer) {
//        System.out.println("In remove of MetadataDispenser!");
        objSubscribers.remove(abaRenderer);
        objSubscribers.trimToSize();
    }

    public void add(AbaRenderer abaRenderer) {
        objSubscribers.add(abaRenderer);
    }

    public int getCount() {
        return objSubscribers.size();
    }

    public void setHorizontalSplitterClass(MetaClass theMetaClass) {
        this.theHorizontalSplitterClass = theMetaClass;
    }

    public void setVerticalSplitterClass(MetaClass theMetaClass) {
        this.theVerticalSplitterClass = theMetaClass;
    }

    public MetaClass getDefaultPanelClass() {
        return theDefaultPanelClass;
    }

    public void setDefaultPanelClass(MetaClass theMetaClass) {
        theDefaultPanelClass = theMetaClass;
    }

    public GlobalInterface getGlobalInterface() {
        return theGlobalInterface;
    }

}
