/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;


/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 9, 2003
 * Time: 11:32:05 AM
 *
 * @@class MetaDataAdminstrator -
 *
 *  purpose:    Defines a versioning system for metadata, including application of changes
 * to metadata.
 *
 */

public class MetadataAdministrator {
    MetadataAdministrator thePreviousVersioning;
    public int iVersionNumber = 0;
    public int iSubrevisionNumber = 0;
    public int iRevisionNumber = 0;
    public int iBuildNumber = 0;
    MetaProject theDesignProject;
    MetadataChanges theChanges = new MetadataChanges();

    public MetadataAdministrator(MetadataDispenser theMetadataDispenser, electric.xml.Element xmlVersion) {
//        this.theDesignProject = theDesignProject;
        electric.xml.Element xmlVersionNumber = xmlVersion.getElement("VersionNumber");
        if (xmlVersionNumber != null) {
            Integer theVersionNumber = new Integer(xmlVersionNumber.getTextString());
            iVersionNumber = theVersionNumber.intValue();
        }
        electric.xml.Element xmlRevisionNumber = xmlVersion.getElement("RevisionNumber");
        if (xmlRevisionNumber != null) {
            Integer theRevisionNumber = new Integer(xmlRevisionNumber.getTextString());
            iRevisionNumber = theRevisionNumber.intValue();
        }
        electric.xml.Element xmlSubrevisionNumber = xmlVersion.getElement("SubrevisionNumber");
        if (xmlSubrevisionNumber != null) {
            Integer theSubrevisionNumber = new Integer(xmlSubrevisionNumber.getTextString());
            iSubrevisionNumber = theSubrevisionNumber.intValue();
        }
        electric.xml.Element xmlBuildNumber = xmlVersion.getElement("BuildNumber");
        if (xmlBuildNumber != null) {
            Integer theBuildNumber = new Integer(xmlBuildNumber.getTextString());
            iBuildNumber = theBuildNumber.intValue();
        }
//        electric.xml.Element xmlWhatChanged = xmlVersion.getElement("Changes");
//        load(xmlWhatChanged);
//        // Check for previous versions
//        xmlVersion = xmlVersion.getElement("Version");
//        if (xmlVersion != null) {
//            thePreviousVersioning = new MetadataAdministrator(theDesignProject, xmlVersion);
//            // if the project is newer then stop this recursion.
//            if (thePreviousVersioning.calculateVersionMagnitude() <=
//                    MetadataAdministrator.calculateVersionMagnitude(theDesignProject.iMetadataVersion,
//                            theDesignProject.iMetadataRevision, theDesignProject.iMetadataSubrevision,
//                            theDesignProject.iMetadataBuild))
//                thePreviousVersioning = null;
//        }
    }

    private void load(electric.xml.Element xmlWhatChanged) {
        // New classes are skipped - there is no conflict.
        // Deletions and Changes ordered by class.
        if (xmlWhatChanged == null)
            return;
        electric.xml.Elements xmlConstants = xmlWhatChanged.getElements("Constants");
        int iConstantCount = xmlConstants.size();
        for (int i = 0; i < iConstantCount; i++) {
            electric.xml.Element xmlConstant = xmlConstants.next();
            // check if constant is added or deleted.
            // no processing for these cases.
            // if constant changes then we need to process.
        }
        electric.xml.Elements xmlClasses = xmlWhatChanged.getElements("Classes");
        int iClassCount = xmlClasses.size();
        for (int i = 0; i < iClassCount; i++) {
            electric.xml.Element xmlClass = xmlClasses.next();
            String sClass = xmlClass.getTextString();
            // ok, we need to see if a class was added or deleted first.
            electric.xml.Element xmlCommand = xmlClass.getElement("Command");
            if (xmlCommand != null) {
                String sCommand = xmlCommand.getTextString();
                if (sCommand.equalsIgnoreCase("add")) {
                    MetadataChange theEvent = MetadataChange.createClassAdditionTrace(sClass);
                    theChanges.addChange(theEvent);
                } else if (sCommand.equalsIgnoreCase("delete")) {
                    MetadataChange theEvent = MetadataChange.createClassRemovalTrace(sClass);
                    theChanges.addChange(theEvent);
                } else if (sCommand.equalsIgnoreCase("data")) {
                    String sNewFactory = null;
                    String sNewType = null;
                    String sNewLongType = null;
                    String sOldFactory = null;
                    String sOldType = null;
                    String sOldLongType = null;
                    electric.xml.Element xmlFactory = xmlClass.getElement("Factory");
                    electric.xml.Element xmlType = xmlClass.getElement("Type");
                    electric.xml.Element xmlLongType = xmlClass.getElement("LongType");
                    if (xmlFactory != null) {
                        electric.xml.Element xmlOldName = xmlFactory.getElement("OldName");
                        sOldFactory = xmlOldName.getTextString();
                        electric.xml.Element xmlNewName = xmlFactory.getElement("NewName");
                        sNewFactory = xmlNewName.getTextString();
                    }
                    if (xmlType != null) {
                        electric.xml.Element xmlOldName = xmlType.getElement("OldName");
                        sOldType = xmlOldName.getTextString();
                        electric.xml.Element xmlNewName = xmlType.getElement("NewName");
                        sNewType = xmlNewName.getTextString();
                    }
                    if (xmlLongType != null) {
                        electric.xml.Element xmlOldName = xmlLongType.getElement("OldName");
                        sOldLongType = xmlOldName.getTextString();
                        electric.xml.Element xmlNewName = xmlLongType.getElement("NewName");
                        sNewLongType = xmlNewName.getTextString();
                    }
                    MetadataChange theEvent = MetadataChange.createClassInformationChangedTrace(sNewFactory, sNewType, sNewLongType, sOldFactory, sOldType, sOldLongType);
                    theChanges.addChange(theEvent);
                } else if (sCommand.equalsIgnoreCase("name")) {
                    electric.xml.Element xmlOldName = xmlClass.getElement("OldName");
                    String sOldClass = null;
                    if (xmlOldName != null)
                        sOldClass = xmlOldName.getTextString();
                    MetadataChange theEvent = MetadataChange.createClassNameChangedTrace(sOldClass, sClass);
                    theChanges.addChange(theEvent);
                }
            }
            // we look if properties changed.
            electric.xml.Elements xmlProperties = xmlClass.getElements("Property");
            int iPropertyCount = xmlProperties.size();
            for (int j = 0; j < iPropertyCount; j++) {
                electric.xml.Element xmlProperty = xmlProperties.next();
                String sProperty = xmlProperty.getTextString();
                // ok, we need to see if a class was added or deleted first.
                electric.xml.Element xmlPropertyCommand = xmlClass.getElement("Command");
                if (xmlPropertyCommand != null) {
                    String sCommand = xmlPropertyCommand.getTextString();
                    if (sCommand.equalsIgnoreCase("add")) {
                        MetadataChange theEvent = MetadataChange.createPropertyAdditionTrace(sProperty);
                        theChanges.addChange(theEvent);
                    } else if (sCommand.equalsIgnoreCase("delete")) {
                        MetadataChange theEvent = MetadataChange.createPropertyRemovalTrace(sProperty);
                        theChanges.addChange(theEvent);
                    } else if (sCommand.equalsIgnoreCase("type")) {
                        String sNewType = null;
                        String sOldType = null;
                        electric.xml.Element xmlType = xmlClass.getElement("Type");
                        if (xmlType != null) {
                            electric.xml.Element xmlOldName = xmlType.getElement("OldName");
                            sOldType = xmlOldName.getTextString();
                            electric.xml.Element xmlNewName = xmlType.getElement("NewName");
                            sNewType = xmlNewName.getTextString();
                        }
                        MetadataChange theEvent = MetadataChange.createPropertyTypeChangedTrace(sClass, sProperty, sOldType, sNewType);
                        theChanges.addChange(theEvent);
                    } else if (sCommand.equalsIgnoreCase("name")) {
                        electric.xml.Element xmlOldName = xmlClass.getElement("OldName");
                        String sOldProperty = null;
                        if (xmlOldName != null)
                            sOldProperty = xmlOldName.getTextString();
                        MetadataChange theEvent = MetadataChange.createPropertyNameChangedTrace(sClass, sProperty, sOldProperty);
                        theChanges.addChange(theEvent);
                    }
                }

            }
        }
    }

    public static int calculateVersionMagnitude(int version, int revision, int subrevision, int build) {
        return (build + 0x100 * subrevision + 0x10000 * revision + 0x1000000 * version);
    }

    public int calculateVersionMagnitude() {
        return (iBuildNumber + 0x100 * iSubrevisionNumber + 0x10000 * iRevisionNumber + 0x1000000 * iVersionNumber);
    }

    int getChangeCount() {
        int iChanges = 0;
        if (thePreviousVersioning != null) {
            // only go up a level if the metadata of the project is older.
            if (thePreviousVersioning.calculateVersionMagnitude() >
                    MetadataAdministrator.calculateVersionMagnitude(theDesignProject.iMetadataVersion,
                            theDesignProject.iMetadataRevision, theDesignProject.iMetadataSubrevision,
                            theDesignProject.iMetadataBuild))
                iChanges = thePreviousVersioning.getChangeCount();
        }
        iChanges += theChanges.getChangeCount();
        return iChanges;
    }

    String getChangeDescription(int iChange) {
        int iPreviousChanges = 0;
        if (thePreviousVersioning != null) {
            // only go up a level if the metadata of the project is older.
            if (thePreviousVersioning.calculateVersionMagnitude() >
                    MetadataAdministrator.calculateVersionMagnitude(theDesignProject.iMetadataVersion,
                            theDesignProject.iMetadataRevision, theDesignProject.iMetadataSubrevision,
                            theDesignProject.iMetadataBuild))
                iPreviousChanges = thePreviousVersioning.getChangeCount();
        }
        if (iChange < iPreviousChanges)
            return thePreviousVersioning.getChangeDescription(iChange);
        // Now take offset to address the current version changes.
        iChange -= iPreviousChanges;
        MetadataChange theChange = theChanges.getChange(iChange);
        if (theChange != null)
            return theChange.getDescription();
        return null;
    }

    boolean applyChanges() {    // you must load the project before you call this method.
        MetaObject theObject = theDesignProject.getFirstObject();
        while (theObject != null) {
            applyChanges(theObject);
            theObject = theObject.theNextObject;
        }
        return true;
    }

    private boolean applyChanges(MetaObject theObject) {
        boolean bRetVal = true;
        if (thePreviousVersioning != null) {
            // only go up a level if the metadata of the project is older.
            if (thePreviousVersioning.calculateVersionMagnitude() >
                    MetadataAdministrator.calculateVersionMagnitude(theDesignProject.iMetadataVersion,
                            theDesignProject.iMetadataRevision, theDesignProject.iMetadataSubrevision,
                            theDesignProject.iMetadataBuild))
                bRetVal = thePreviousVersioning.applyChanges();
        }
        int iChangeCount = getChangeCount();
        for (int i = 0; i < iChangeCount; i++) {
            MetadataChange theChange = theChanges.getChange(i);
            switch (theChange.iChangeType) {
                case MetadataChange.CLASS_ADDED:
                    continue;  // doesn't change existing objects.
                case MetadataChange.CLASS_INFORMATION_CHANGED:
                    {
                        if (theObject.theType.theName.equals(theChange.sOldClassName))
                            theObject.theType = new MetaType(theChange.sNewClassName,
                                    theChange.sNewTypeLongName,
                                    theChange.sNewFactoryName,
                                    theDesignProject);
                        continue;
                    }
                case MetadataChange.CLASS_NAME_CHANGED:
                    {
                        if (theObject.theType.theName.equals(theChange.sOldClassName))
                            theObject.theType = new MetaType(theChange.sNewClassName, theDesignProject);
                        continue;
                    }
                case MetadataChange.CLASS_REMOVED:
                    {
                        if (theObject.theType.theName.equals(theChange.sOldClassName)) {
                            // Generate error!
                            bRetVal = false;
                        }
                        continue;
                    }
                case MetadataChange.CONSTANT_DEFINITION_ADDED:
                    continue;
                case MetadataChange.CONSTANT_DEFINITION_CHANGED:
                    continue;
                case MetadataChange.CONSTANT_DEFINITION_REMOVED:
                    continue;
                case MetadataChange.PROPERTY_ADDED:
                    continue;
                case MetadataChange.PROPERTY_NAME_CHANGED:
                    if (theObject.theType.theName.equals(theChange.sOldClassName)) {
                        MetaProperty theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName);
                        if (theProperty != null) {
                            theProperty.theName = theChange.sNewPropertyName;
                        }
                    }
                    continue;
                case MetadataChange.PROPERTY_REMOVED:
                    if (theObject.theType.theName.equals(theChange.sOldClassName)) {
                        MetaProperty theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName);
                        if (theProperty != null) {
                            // error.
                            bRetVal = false;
                        }
                    }
                    continue;
                case MetadataChange.PROPERTY_TYPE_CHANGED:
                    if (theObject.theType.theName.equals(theChange.sOldClassName)) {
                        MetaProperty theProperty = theObject.getPropertyMetadata(theChange.sOldPropertyName);
                        if (theProperty != null) {
                            ((MetaParameter) theProperty.theIndexedValue.get(0)).theSimpleType = theChange.sNewPropertyType;
                        }
                    }
                    continue;
            }
        }
        return bRetVal;
    }

}
