/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.HashMap;


/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 *
 *          <Type>
 <Name>text value that denotes the type of the
 object (class or base type)</Name>
 <FullName>text value that denotes the type of the object
 (full name of class or base type)</FullName> Optional tag not used for native types.
 <FactoryName>method name of constructor to
 call</FactoryName>  @  (optional tag)
 {Parameter Declarations} *   <--- Zero or more parameter
 declarations.
 </Type>

 *
 */

public class MetaType {
    public String theName = "";  // the type name.
    public String theFullName = null;
    public String theFactoryName = null;
    public MetaParameter theFirstParameter = null;
    public MetaParameter theLastParameter = null;
    public int iParameterCount = 0;
    public MetaProject theDesignProject = null;
    private static HashMap HashPropList;

    public MetaType(MetaProject theDesignProject) {
        this.theName = "None";
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, String theFullName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theFullName = theFullName;
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, String theFullName, String theFactoryName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theFullName = theFullName;
        this.theFactoryName = theFactoryName;
        this.theDesignProject = theDesignProject;
    }

    public void addParameter(MetaParameter theMetaParameter) {
        if (theFirstParameter == null)
            theFirstParameter = theMetaParameter;
        else {
            theMetaParameter.thePreviousParameter = theLastParameter;
            theLastParameter.theNextParameter = theMetaParameter;
        }
        iParameterCount++;
        theLastParameter = theMetaParameter;
    }

    public boolean save(electric.xml.Element theParent) {
        electric.xml.Element xmlType = new electric.xml.Element("Type");
        theParent.addElement(xmlType);
        electric.xml.Element xmlName = new electric.xml.Element("Name");
        xmlName.setText(theName);
        xmlType.addElement(xmlName);
        electric.xml.Element xmlFullName = new electric.xml.Element("FullName");
        xmlFullName.setText(theFullName);
        xmlType.addElement(xmlFullName);
        electric.xml.Element xmlFactoryName = new electric.xml.Element("FactoryName");
        xmlFactoryName.setText(theFactoryName);
        xmlType.addElement(xmlFactoryName);
        // Process the languages.
        MetaParameter theParameter = theFirstParameter;
        while (theParameter != null) {
            theParameter.save(xmlType);
            theParameter = theParameter.theNextParameter;
        }
        return true;
    }

    public boolean load(electric.xml.Element theElement) {
        electric.xml.Element xmlName = theElement.getElement("Name");
        theName = xmlName.getTextString();
        electric.xml.Element xmlFullName = theElement.getElement("FullName");
        theFullName = xmlFullName.getTextString();
        electric.xml.Element xmlFactoryName = theElement.getElement("FactoryName");
        theFactoryName = xmlFactoryName.getTextString();
        // Process the languages.
        electric.xml.Elements xmlParameters = theElement.getElements("Parameter");
        electric.xml.Element xmlParameter = xmlParameters.next();
        int i = 0;
        while (xmlParameter != null) {
            MetaParameter theMetaParameter = new MetaParameter();
            theMetaParameter.theDesignProject = this.theDesignProject;
            theMetaParameter.load(xmlParameter, i++);
            addParameter(theMetaParameter);
            xmlParameter = xmlParameters.next();
        }
        return true;
    }

    public MetaType Clone() {
        MetaType theReturnValue = new MetaType(theName, theFullName, theFactoryName, theDesignProject);
        MetaParameter theParam = this.theFirstParameter;
        while (theParam != null) {
            MetaParameter theNewParam = theParam.Clone();
            theReturnValue.addParameter(theNewParam);
            theParam = theParam.theNextParameter;
        }
        return theReturnValue;
    }

    public void attachToProject(MetaProject theProj) {
        this.theDesignProject = theProj;
        MetaParameter theParam = theFirstParameter;
        while (theParam != null) {
            theParam.attachToProject(theProj);
            theParam = theParam.theNextParameter;
        }
    }

    public Object Create(String theIdentifier, AbaMetaDataUser theCreator, Hashtable properties) {
        String sDisplayClass = null;

        // Don't pass Rog Misteli any of the "Design" components.  These are internal.
        if ((theFactoryName != null) && ((sDisplayClass == null) || (sDisplayClass.indexOf("Design") == -1))) {

            Class clsFactory = null;
            Object objFactory = null;
            try {
                HammerClassLoader clsLoader = (HammerClassLoader) theDesignProject.theClassLoader;
                clsFactory = Class.forName(theFactoryName, true, clsLoader.theLoader);
                objFactory = clsFactory.newInstance();
            } catch (Exception e3) {
                e3.printStackTrace(); // printing a stack-trace so the renderer sees it
            }
            if (objFactory != null) {
                try {
                    Class[] classesFactoryConstructor = new Class[5];
                    Object[] objectsFactoryConstructor = new Object[5];
                    classesFactoryConstructor[0] = Class.forName("ch.abacus.lib.util.GlobalInterface");
                    classesFactoryConstructor[1] = theFactoryName.getClass();
                    classesFactoryConstructor[2] = theFactoryName.getClass();
                    classesFactoryConstructor[3] = Boolean.TYPE;
                    classesFactoryConstructor[4] = Class.forName("java.util.Hashtable");
                    objectsFactoryConstructor[0] = theDesignProject.theGlobalInterface;
                    objectsFactoryConstructor[1] = theFullName;
                    objectsFactoryConstructor[2] = theIdentifier;

                    if (theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE)
                        objectsFactoryConstructor[3] = new Boolean(true);  // false for renderer true for ide.
                    else
                        objectsFactoryConstructor[3] = new Boolean(theDesignProject.getMetaDataUser().getAttachedToDesigner());
                    objectsFactoryConstructor[4] = properties; //theCreator.getPropertyHashTable();
                    Method methodFactoryConstructor = clsFactory.getMethod("createComponent", classesFactoryConstructor);
                    return methodFactoryConstructor.invoke(objFactory, objectsFactoryConstructor);
                } catch (Exception e4) {
                    e4.printStackTrace(); // printing a stack-trace so the renderer sees it
                }
            }
        } else {
            Class cls = null;
            try {
                cls = Class.forName(theFullName);
            } catch (ClassNotFoundException e1) {
                return null;
            }
            Class[] classes;
            Object[] objects;

            if (theName.equals("JAFrame")) {
                classes = new Class[1];
                objects = new Object[1];
                classes[0] = Boolean.TYPE;
                objects[0] = Boolean.FALSE;
            } else {
                classes = new Class[0];
                objects = new Object[0];
            }
            try {
                Constructor theConstructor = cls.getConstructor(classes);
                return theConstructor.newInstance(objects);
            } catch (Exception e2) {
                e2.printStackTrace(); // printing a stack-trace so the renderer sees it
            }
        }

        return null;
    }

    public Object Create(String theIdentifier, MetaObject theCreator) {
        ClassLoader theLoader;
        if(HashPropList ==null )
            HashPropList = new HashMap();
        String sDisplayClass = null;
        if ((theCreator != null) && (theCreator.iMode == MetaObject.DESIGN_MODE))
            sDisplayClass = theCreator.theClass.theMetadata.sDisplayClass;
        theLoader = theDesignProject.getMetaDataUser().getClassLoader().getLoader();
        // Don't pass Rog Misteli any of the "Design" components.  These are internal.
        if ((theFactoryName != null) && ((sDisplayClass == null) || (sDisplayClass.indexOf("Design") == -1))) {
            MetaParameter theParameter = theFirstParameter;
            Class[] classes = new Class[iParameterCount];
            Object[] objects = new Object[iParameterCount];


//  public JAComponent createComponent(GlobalInterface theGlobalInterface, String className, String componentName, boolean designMode, Hashtable properties) {
//
//className is the full class name of the class to instantiate
//(for example ch.abacus.lib.ui.JAButton)
//componentName is the name of the component. This can also be an internal
//name that does not correspond to a set/get metapher
//designMode: you can pass true or false to indicate if the component is
//instantiated thrue the Designer at design time or thrue the renderer at
//runtime. Since there could be event listeners that you have no knowledge
//about (so you can't remove them), the factory can do this here.
//properties: A Hashtable with all the properties you have (position, name,
//etc... simply everything).

            while (theParameter != null) {
                try {
                    if (theParameter.theComplexType != null)
                        classes[theParameter.theOrder] = Class.forName(theParameter.theComplexType.theFullName);
                    else
                        classes[theParameter.theOrder] = Class.forName(theParameter.theSimpleType);
                } catch (ClassNotFoundException e2) {
                    return null;
                }
                if (theParameter.theComplexType != null)
                    objects[theParameter.theOrder] = theParameter.theComplexType.Create(null, (MetaObject) null);
                else {
                    int iType = theParameter.theValue.iType;
                    classes[theParameter.theOrder] = MetaPropertyValueEx.getTypeAsClass(iType);
                    Object oValue = theParameter.theValue.getNativeValue();
                    Object theResolvedValue = null;
                    try {
                        theResolvedValue = MetaConstantGroup.resolve(oValue,
                                theCreator.theDesignProject.getMetadataDispenser(), theLoader);
                    } catch (HammerException e) {
                        if (theDesignProject.getMetaDataUser().getLogFile() != null)
                            theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot create constant " + oValue);
                        return null;
                    }
                    if (theResolvedValue instanceof String) {
                        // before setting prop in design cockpit do translation
                        theResolvedValue = theCreator.theDesignProject.getNLS().getTranslatedValue
                                ((String) theResolvedValue,
                                        theCreator.theDesignProject.theCurrentLanguage.theLanguage, theParameter.theValue.bMnemonic);
                    }
                    if (classes[theParameter.theOrder] == char.class) {
                        if (theResolvedValue instanceof String)
                            theResolvedValue = new Character(((String) theResolvedValue).charAt(0));
                    }
                    objects[theParameter.theOrder] = theResolvedValue;
                }
                theParameter = theParameter.theNextParameter;
            }
            Class clsFactory = null;
            Object objFactory = null;
            try {
                HammerClassLoader clsLoader = (HammerClassLoader) theCreator.theDesignProject.theClassLoader;
                clsFactory = Class.forName(theFactoryName, true, clsLoader.theLoader);
                objFactory = clsFactory.newInstance();
            } catch (Exception e3) {
                if (theDesignProject.getMetaDataUser().getLogFile() != null)
                    theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot find Factory class " + theFactoryName);
                return null;
            }
            if (objFactory != null) {
                try {
                    Class[] classesFactoryConstructor = new Class[5];
                    Object[] objectsFactoryConstructor = new Object[5];
                    classesFactoryConstructor[0] = Class.forName("ch.abacus.lib.util.GlobalInterface");
                    classesFactoryConstructor[1] = theFactoryName.getClass();
                    classesFactoryConstructor[2] = theFactoryName.getClass();
                    classesFactoryConstructor[3] = Boolean.TYPE;
                    classesFactoryConstructor[4] = Class.forName("java.util.Hashtable");
                    objectsFactoryConstructor[0] = theCreator.theDesignProject.theGlobalInterface;
                    objectsFactoryConstructor[1] = theFullName;
                    objectsFactoryConstructor[2] = theIdentifier;

                    if (theCreator.theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE)
                        objectsFactoryConstructor[3] = new Boolean(true);  // false for renderer true for ide.
                    else
                        objectsFactoryConstructor[3] = new Boolean(theCreator.theDesignProject.getMetaDataUser().getAttachedToDesigner());

                    if(HashPropList.get(theFullName)==null)
                    {
                        objectsFactoryConstructor[4] =theCreator.getPropertyHashTable();
                        HashPropList.put(theFullName,objectsFactoryConstructor[4]);
                    }
                    else
                    {
                        objectsFactoryConstructor[4] = HashPropList.get(theFullName);
                    }

                    Method methodFactoryConstructor = clsFactory.getMethod("createComponent", classesFactoryConstructor);
                    return methodFactoryConstructor.invoke(objFactory, objectsFactoryConstructor);
                } catch (Exception e4) {
                    if (theDesignProject.getMetaDataUser().getLogFile() != null)
                        theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot invoke Factory class " + theFactoryName);
                    return null;
                }
            }
        } else {
            Class cls = null;
            String invokingClassName = null;
            try {
                if ((theCreator != null) && (theCreator.iMode == MetaObject.DESIGN_MODE)) {
                    invokingClassName = theCreator.theClass.theMetadata.sDisplayClass;
                    cls = Class.forName(theCreator.theClass.theMetadata.sDisplayClass);
                } else {
                    invokingClassName = theFullName;
                    int iType = MetaPropertyValueEx.TYPE_UNDEFINED;
                    if (theFullName != null)
                        iType = MetaPropertyValueEx.translateType(theFullName);
                    if ((iType == MetaPropertyValueEx.TYPE_UNDEFINED) && (theFullName != null))
                        cls = Class.forName(theFullName);
                    else {
                        MetaArgumentList theArguments = new MetaArgumentList(this.iParameterCount);
                        MetaParameter theParameter = this.theFirstParameter;
                        int i = 0;
                        while (theParameter != null) {
                            theArguments.setArgument(i++, theParameter);
                            theParameter = theParameter.theNextParameter;
                        }
                        return theArguments;
                    }
                }
            } catch (ClassNotFoundException e1) {
                if (theDesignProject.getMetaDataUser().getLogFile() != null)
                    theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot find Display class " + invokingClassName);
                return null;
            }
            MetaParameter theParameter = theFirstParameter;
            Class[] classes;
            Object[] objects;
            if (invokingClassName.endsWith("JAFrame")) {
                classes = new Class[1];
                objects = new Object[1];
                classes[0] = Boolean.TYPE;
                objects[0] = Boolean.FALSE;
            } else {
                classes = new Class[iParameterCount];
                objects = new Object[iParameterCount];
            }

            while (theParameter != null) {
                try {
                    if (theParameter.theComplexType != null)
                        classes[theParameter.theOrder] = Class.forName(theParameter.theComplexType.theFullName);
                    else {
                        int iType = MetaPropertyValueEx.translateType(theParameter.theSimpleType);
                        if (iType != MetaPropertyValueEx.TYPE_UNDEFINED)
                            classes[theParameter.theOrder] = MetaPropertyValueEx.getTypeAsClass(iType);
                        else
                            classes[theParameter.theOrder] = Class.forName(theParameter.theSimpleType);
                    }
                } catch (ClassNotFoundException e2) {
                    return null;
                }
                if (theParameter.theComplexType != null)
                    objects[theParameter.theOrder] = theParameter.theComplexType.Create(null, (MetaObject) null);
                else {
                    objects[theParameter.theOrder] = theParameter.theValue.getNativeValue();
                }
                theParameter = theParameter.theNextParameter;
            }
            try {
                Constructor theConstructor = cls.getConstructor(classes);
                return theConstructor.newInstance(objects);
            } catch (Exception e2) {
                if (theDesignProject.getMetaDataUser().getLogFile() != null)
                    theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Error invoking Constructor for " + invokingClassName);
                e2.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getLiteralValue() {
        String sPrefix = "new " + theName + "(";
        String sSuffix = ")";
        String sInsideStuff = "";

        MetaParameter theParameter = theFirstParameter;
        while (theParameter != null) {
            if (sInsideStuff.length() > 0)
                sInsideStuff = sInsideStuff + ",";
            sInsideStuff = sInsideStuff + theParameter.getLiteralValue();
            theParameter = theParameter.theNextParameter;
        }
        return sPrefix + sInsideStuff + sSuffix;
    }

    public void setMnemonic() {
        MetaParameter theParameter = theFirstParameter;
        while (theParameter != null) {
            theParameter.setMnemonic();
            theParameter = theParameter.theNextParameter;
        }
    }

    public boolean getMnemonic() {
        MetaParameter theParameter = theFirstParameter;
        while (theParameter != null) {
            boolean bMnemonic = theParameter.getMnemonic();
            if (bMnemonic == true)
                return true;
            theParameter = theParameter.theNextParameter;
        }
        return false;
    }
}
