/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class MetaMethod {
    String sMethodName = null;
    String sMethodText = "";
    String sMethodDoc = "";
    MetaMethod theNextMethod = null;

    public MetaMethod(String theMethodName) {
        sMethodName = theMethodName;
    }

    public MetaMethod(String theMethodName, String theCode, String theDoc) {
        sMethodName = theMethodName;
        sMethodText = theCode;
        sMethodDoc = theDoc;
    }

    public MetaMethod(MetaMethod theCloneableMethod) {
        sMethodName = new String(theCloneableMethod.sMethodName);
        sMethodText = new String(theCloneableMethod.sMethodText);
        sMethodDoc = new String(theCloneableMethod.sMethodDoc);
    }

    public String getCode() {
        return sMethodText;
    }

    public String getDoc() {
        return sMethodDoc;
    }

    public void setCode(String theCode) {
        sMethodText = theCode;
    }

    public void setDoc(String theDoc) {
        sMethodDoc = theDoc;
    }

    public void setNextMethod(MetaMethod theMethod) {
        theNextMethod = theMethod;
    }

    public MetaMethod getNextMethod() {
        return theNextMethod;
    }

    public String getMethodName() {
        return sMethodName;
    }

    static public boolean IsStub(String sCode) {
        // Scan for first {
        if (sCode != null) {
            sCode = sCode.substring(sCode.indexOf("{") + 1, sCode.length());
            // Scan for next }
            int iRightCurlyBracket = sCode.lastIndexOf("}");
            if (iRightCurlyBracket <= 0)  // By itself or missing brace means it's garbage.
                return true;
            sCode = sCode.substring(0, iRightCurlyBracket - 1);
            // Trim the result.
            sCode = sCode.trim();
            // Check if length is greater than zero.
            if (sCode.length() == 0)
                return true;
            // Check out if not forward to super...
            int iPos = sCode.indexOf("super.");
            if (iPos == -1)
                return false;
            // Count semi-colons and left parents.
            iPos = sCode.indexOf(";");
            if (iPos != -1) {
                iPos = sCode.indexOf(";", iPos + 1);
                if (iPos != -1)
                    return false;
            }
            iPos = sCode.indexOf("{");
            if (iPos != -1) {
                iPos = sCode.indexOf("(", iPos + 1);
                if (iPos != -1)
                    return false;
            }
        }
        return true;
    }
}
