/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 7, 2003
 * Time: 11:34:18 AM
 * To change this template use Options | File Templates.
 */
public class MetaConstantGroupCollection {

    ArrayList groupList = new ArrayList(0);
    public MetaConstantGroupCollection theNextSibling;
    public MetaConstantGroupCollection thePreviousSibling;
    public String sClassName;
    MetadataDispenser theMetadataDispenser;

    public MetaConstantGroupCollection(String sClassName, MetadataDispenser theMetadataDispenser) {
        this.sClassName = sClassName;
        this.theMetadataDispenser = theMetadataDispenser;
    }

    public void addGroup(MetaConstantGroup theGroup) {
        groupList.add(theGroup);
    }

    /**
     * Removes a Group from the Collection of Groups
     * @param theGroup - the MetaConstantGroup to remove from the collection
     * @return true, if the group is removed; false, otherwise.
     */
    public boolean removeGroup(MetaConstantGroup theGroup) {
        return groupList.remove(theGroup);
    }

    /**
     * Removes all groups from the list of groups.<p>
     * This is used, for example, in the Metadata Editor
     */
    public void clearGroups() {
        groupList.clear();
    }

    public int getGroupCount() {
        return groupList.size();
    }

    public MetaConstantGroup getGroup(int index) {
        return (MetaConstantGroup) groupList.get(index);
    }

    public ArrayList getConstantList() {
        ArrayList retVal = new ArrayList(0);
        int iGroupSize = getGroupCount();
        for (int i = 0; i < iGroupSize; i++) {
            MetaConstantGroup thisGroup = getGroup(i);
            ArrayList theseConstants = thisGroup.getConstantList();
            int iKeyCount = theseConstants.size();
            for (int j = 0; j < iKeyCount; j++) {
                retVal.add(theseConstants.get(j));
            }
        }
        return retVal;
    }

    public String get(String sName) {
        int iGroupSize = getGroupCount();
        for (int i = 0; i < iGroupSize; i++) {
            MetaConstantGroup thisGroup = getGroup(i);
            String sRetVal = thisGroup.get(sName);
            if (sRetVal != null)
                return sRetVal;
        }
        return null;
    }

    public String getKey(String sValue) {
        int iGroupSize = getGroupCount();
        for (int i = 0; i < iGroupSize; i++) {
            MetaConstantGroup thisGroup = getGroup(i);
            String sRetVal = thisGroup.getKey(sValue);
            if (sRetVal != null)
                return sRetVal;
        }
        return null;
    }

}
