/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;


/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEComponentPaletteNode extends CheckTreeNode {
    public static final int TEXT = 0;
    public static final int META_CLASS = 1;
    public static final int DATA_ELEMENT = 2;
    public static final int DATA_ELEMENT_GROUP = 3;
    public static final int DATA_TABLE = 4;
    public static final int DATA_CONNECTION = 5;

    MetaClass theMetaClass = null;
    private CustomizerDataElementInterface theCustomizerDataElement = null;
    private CustomizerDataTableInterface theCustomizerDataTable = null;
    private CustomizerDataConnectionInterface theCustomizerDataConnection;
    public int nodeType;
    public boolean deferredNode = false;  // this is used by the Customizer only to denote a node representing deferred DataElements.


    public IDEComponentPaletteNode(MetaClass theClass) {
        //super(theClass.getMetadata().sClassName);
        super(theClass.getMetadata().getDisplayName());
        theMetaClass = theClass;
        nodeType = META_CLASS;
    }

    public IDEComponentPaletteNode(String theText) {
        super(theText);
        nodeType = TEXT;
    }

    public IDEComponentPaletteNode(String theText, int nodeType) {
        super(theText);
        this.nodeType = nodeType;
    }

    public IDEComponentPaletteNode(CustomizerDataTableInterface theCustomizerDataTable, boolean bDeferred) {
        super(theCustomizerDataTable.getDisplayName());
        this.theCustomizerDataTable = theCustomizerDataTable;
        this.nodeType = DATA_TABLE;
        this.deferredNode = bDeferred;
    }

    /**
     * This contructor is used by the Customizer to display a custom label, but represent a metaclass
     * @param theClass - the metaclass to represent
     * @param theCustomizerDataElement - the AbaDataElement to represent
     */
    public IDEComponentPaletteNode(MetaClass theClass, CustomizerDataElementInterface theCustomizerDataElement) {
        super(theCustomizerDataElement.getDisplayName());
        theMetaClass = theClass;
        this.theCustomizerDataElement = theCustomizerDataElement;
        this.nodeType = DATA_ELEMENT;
    }

    public IDEComponentPaletteNode(CustomizerDataConnectionInterface theCustomizerDataConnection) {
        super(theCustomizerDataConnection.getTablesDisplayName());
        this.theCustomizerDataConnection = theCustomizerDataConnection;
        this.nodeType = DATA_CONNECTION;
    }

    public MetaClass getMetaClass() {
        return theMetaClass;
    }

    public CustomizerDataElementInterface getCustomizerDataElement() {
        return theCustomizerDataElement;
    }

    public CustomizerDataTableInterface getCustomizerDataTable() {
        return theCustomizerDataTable;
    }

    public CustomizerDataConnectionInterface getCustomizerDataConnection() {
        return theCustomizerDataConnection;
    }

    public boolean isCustomizerDataElementGroup() {
        if (getCustomizerDataElement() != null)
            return (getCustomizerDataElement().getDataElementCount() > 0);
        else
            return false;
    }

    public boolean isCustomizerDataElement() {
        return (nodeType == DATA_ELEMENT);
    }

    public boolean isCustomizerDataTable() {
        return (nodeType == DATA_TABLE);
    }

    public boolean isCustomizerDataConnection() {
        return (nodeType == DATA_CONNECTION);
    }
}
