/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import org.comedia.text.CJavaHighlighter;

import javax.swing.*;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import java.awt.*;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;


/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:35:12 PM
 * To change this template use Options | File Templates.
 */

public class HammerSourceEditor extends org.comedia.ui.CSyntaxEditor {
    Hashtable actions;
    public HammerEditorPopupMenu thePopupMenu = null;

    public static final int UNDO_LIMIT = 1500;

    //UndoManager
    private UndoManager m_undoManager;
    private int iMaxLine = 74;
    private int iIndent = 2;
    private String sStickyDelims = ",";
    private String sDelims = "(+";
//    <StickyDelims>,</StickyDelims>
//    <Delims>(+</Delims>
//    <Indentation>2</Indentation>
//    <MaxLineLength>74</MaxLineLength>

    public HammerSourceEditor() {
        super();
        setSyntaxHighlighter(new CJavaHighlighter());
        createActionTable();
        //add the UndoableEditListener to the TextArea
        getDocument().addUndoableEditListener(this);
        createUndoMananger();
    }

    public HammerSourceEditor(String sDelims, String sStickyDelims, int iIndent, int iMaxLine) {
        super();
        this.sDelims = sDelims;
        this.sStickyDelims = sStickyDelims;
        this.iIndent = iIndent;
        this.iMaxLine = iMaxLine;
        setSyntaxHighlighter(new CJavaHighlighter());
        createActionTable();
        //add the UndoableEditListener to the TextArea
        getDocument().addUndoableEditListener(this);
        createUndoMananger();
    }

    /**
     * setCode - sets the code of the source viewer.
     *           This method sets the code, running it through the code formattter first.
     * @param sText
     */
    public void setCode(String sText) {
        StringReader theStringReader = new StringReader(sText);
        com.ibm.cf.CodeFormatter theFormatter = new com.ibm.cf.CodeFormatter();
        StringWriter theWriter = new StringWriter(sText.length());
        if (sDelims != null)
            theFormatter.setDelimiters(sDelims);
        if (sStickyDelims != null)
            theFormatter.setStickyDelimiters(sStickyDelims);
        theFormatter.setIndentationStep(iIndent);
        if (iMaxLine != 0)
            theFormatter.setMaxLineLength(iMaxLine);
        theFormatter.formatCode(theStringReader, theWriter);
        theStringReader = new StringReader(theWriter.getBuffer().toString());
        try {
            read(theStringReader, null);
        } catch (java.io.IOException e1) {
        }
    }

    private void createActionTable() {
        actions = new Hashtable();
        Action[] actionsArray = getActions();
        for (int i = 0; i < actionsArray.length; i++) {
            Action a = actionsArray[i];
            String sActionName = (String) a.getValue(Action.NAME);
//            System.out.println(sActionName);
            actions.put(sActionName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action) (actions.get(name));
    }

    //createUndoMananger creating undo manager
    private void createUndoMananger() {
        m_undoManager = new UndoManager();
        m_undoManager.setLimit(UNDO_LIMIT);
    }

    //undoableEditHappened called when edit happened
    public void undoableEditHappened(UndoableEditEvent e) {
        //add the edits to the unod manager
        m_undoManager.addEdit(e.getEdit());
    }

    public void undo() {
        try {
            //Undo changes
            m_undoManager.undo();
        } catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        try {
            //Redo changes
            m_undoManager.redo();
        } catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }


}
