/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.io.*;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 21, 2003
 * Time: 6:09:15 PM
 * To change this template use Options | File Templates.
 */
public class HammerJarFileEx {
    JarFile theJar;
    JarFile theTempJar;
    File newJarFile;
    ArrayList theExcludeList;
    JarOutputStream jarOutputStream;
    String sJarName;

    public HammerJarFileEx(JarFile theJar) {
        this.theJar = theJar;
        theExcludeList = new ArrayList(0);
        sJarName = theJar.getName();
    }

    public boolean load() {
        return createTempJar();
    }

    public boolean save() {
        boolean bRetVal = true;
        if (jarOutputStream == null)
            return false;
        bRetVal = copyJar();
        try {
            jarOutputStream.close();
        } catch (IOException e) {
            return false;
        }
        if (bRetVal) {
            try {
                theJar.close();
            } catch (IOException e) {
                return false;
            }

        }
        return bRetVal;
    }

    private boolean createTempJar() {
        int iMatch = sJarName.indexOf(".");
        try {
            newJarFile = new File(sJarName + ".tmp");
            if (newJarFile.exists())
                newJarFile.delete();
            newJarFile.createNewFile();
        } catch (IOException e0) {
            System.err.println("Cannot create jar file " + sJarName + ".tmp");
            return false;
        }
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(newJarFile));
            jarOutputStream = null;
            try {
                jarOutputStream = new JarOutputStream(outputStream);
            } catch (IOException e1) {
                System.err.println("Cannot create output stream for jar file " + sJarName + " " + e1);
            }
        } catch (FileNotFoundException e1) {
            return false;
        }
        return true;
    }


    public byte[] getJarEntryBytes(JarFile jarf, JarEntry entry) {
        try {
            InputStream is = jarf.getInputStream(entry);
            int fileLength = (int) entry.getSize();
            int totalbytes = 0;

            // Create an array the same length as the file to hold the compiled class.
            byte[] classBytes = new byte[fileLength];

            while (totalbytes != fileLength) {
                // Read class definition into the array.
                int iBytesToRead = 512;
                if ((fileLength - totalbytes) < 512)
                    iBytesToRead = fileLength - totalbytes;
                int bytesread = is.read(classBytes, totalbytes, iBytesToRead);
                totalbytes += bytesread;
            }
            // Close the file.
            is.close();
            return classBytes;
        } catch (java.io.IOException e2) {
        }
        return null;
    }

    public boolean copyJar() {
        boolean bRetVal = true;
        // Scan through Jar getting all jar entries.
        // If the entry is not in the remove list, write it out.
        Enumeration allentries = theJar.entries();
        while (allentries.hasMoreElements() && bRetVal) {
            JarEntry entry = (JarEntry) allentries.nextElement();
            String sEntryName = entry.getName();
            if (theExcludeList.contains(sEntryName) == false) {
                byte[] theEntryBytes = this.getJarEntryBytes(theJar, entry);
                bRetVal = addJarEntry(sEntryName, theEntryBytes);
            }
        }
        return bRetVal;
    }

    public boolean removeJarEntry(JarEntry theEntry) {
        if (theEntry != null) {
            String sName = theEntry.getName();
            if (sName != null) {
                theExcludeList.add(sName);
                return true;
            }
        }
        return false;
    }

    public boolean addJarEntry(String sName, byte[] theBytes) {
        boolean bRetVal = createJarEntry(sName);
        if (bRetVal) {
            bRetVal = writeJarEntry(theBytes);
        }
        return bRetVal;
    }

    private boolean writeJarEntry(byte[] theBytes) {
        try {
            jarOutputStream.write(theBytes);
        } catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean write(int i) {
        try {
            jarOutputStream.write(i);
        } catch (IOException e) {
            return false;
        }
        return true;
    }

    public JarOutputStream getOutputStream() {
        return this.jarOutputStream;
    }

    public boolean createJarEntry(String sName) {
        JarEntry je = new JarEntry(sName);
        try {
            jarOutputStream.putNextEntry(je);
        } catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean finishJarSave() {
        String sJarFileName = theJar.getName();
        try {
            theJar.close();
        } catch (java.io.IOException e1) {
            return false;
        }
        File theJarFile = new File(sJarFileName);
        if (theJarFile.exists())
            theJarFile.delete();
        boolean bTest = newJarFile.renameTo(theJarFile);
        return bTest;
    }


}
