/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * <p>Title: Abajamm</p>
 * <p>Description: Abacus Java Module Manager</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Abacus </p>
 * @author Michael Gouker - Cagey Logic
 * @version 1.0
 */

public class HammerJarCollection {
    HammerJarEntry firstJar;
    HammerJarEntry lastJar;
    int iJarCount = 0;

    public HammerJarCollection() {
    }

    void addJar(String sName, String sVersion) {
        HammerJarEntry jarEntry = new HammerJarEntry(sName, sVersion);
        if (firstJar == null) {
            firstJar = jarEntry;
        } else {
            lastJar.nextJar = jarEntry;
            jarEntry.prevJar = lastJar;
        }
        lastJar = jarEntry;
        iJarCount++;
    }

    HammerJarEntry getJarByIndex(int iJarNumber) {
        if (iJarNumber < iJarCount) {
            int i = 0;
            HammerJarEntry testJar = firstJar;
            while (testJar != null) {
                if (i++ == iJarNumber)
                    return testJar;
                testJar = testJar.nextJar;
            }
        }
        return null;
    }

    int getJarCount() {
        return iJarCount;
    }

    boolean removeJar(String sName, String sVersion) {
        HammerJarEntry testJar = firstJar;
        HammerJarEntry prevJar = null;
        while (testJar != null) {
            if ((testJar.sName.equals(sName)) && (testJar.sVersion.equals(sVersion))) {
                if (prevJar == null) {
                    firstJar = testJar.nextJar;
                } else {
                    lastJar.nextJar = testJar.nextJar;
                }
                if (testJar.nextJar != null)
                    testJar.nextJar.prevJar = prevJar;
                else
                    lastJar = prevJar;
                iJarCount--;
                return true;
            }
            prevJar = testJar;
            testJar = testJar.nextJar;
        }
        return false;
    }


}

class HammerJarEntry {
    String sName;
    String sVersion;
    HammerJarEntry prevJar;
    HammerJarEntry nextJar;

    public HammerJarEntry(String sName, String sVersion) {
        this.sName = sName;
        this.sVersion = sVersion;
    }
}
