/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;


/**
 * <p>Title: Abajamm</p>
 * <p>Description: Abacus Java Module Manager</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Abacus </p>
 * @author Michael Gouker - Cagey Logic
 * @version 1.0
 */



public class HammerClassLoader {
    HammerClassCustomLoader theLoader;
    AbaMetaDataUser theUser = null;

    public HammerClassLoader(AbaMetaDataUser theUser, String sClassPath, String sShortClassPath) {
        this.theUser = theUser;
        theLoader = new HammerClassCustomLoader(theUser, sClassPath, sShortClassPath);
    }

    public HammerClassCustomLoader getLoader() {
        return theLoader;
    }

    // Allow classes that start with a path name to be loaded.
    public Class[] getClassesFromPath(String sSearchPath) {
        return theLoader.getClassesFromPath(sSearchPath);
    }

    public void setPaths(String sClassLoaderPath, String sShortClassPath) {
        theLoader.setPaths(sClassLoaderPath, sShortClassPath);
    }

    public void setUser(AbaMetaDataUser theUser) {
        this.theUser = theUser;
        theLoader.theUser = theUser;
    }
}


