/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/*
=====================================================================

  CheckTreeCellEditor.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import javax.swing.*;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;


public class CheckTreeCellEditor
        extends CheckTreeCellRenderer
        implements TreeCellEditor, ActionListener {
    protected CellEditorListener list;

    public CheckTreeCellEditor(JTree tree) {
        this(tree, new DefaultTreeCellRenderer());
    }

    public CheckTreeCellEditor(JTree tree, TreeCellRenderer renderer) {
        super(tree, renderer);
        if (check != null)
            check.addActionListener(this);
    }

    public Component getTreeCellEditorComponent(
            JTree tree, Object value, boolean selected,
            boolean expanded, boolean leaf, int row) {
        return getTreeCellRendererComponent(
                tree, value, true, expanded, leaf, row, true);
    }

    public boolean stopCellEditing() {
        return true;
    }

    public Object getCellEditorValue() {
        if ((node != null) && (check != null))
            node.setSelected(check.isSelected());
        return node;
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public void cancelCellEditing() {
        fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        list = SwingEventMulticaster.add(list, listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        list = SwingEventMulticaster.remove(list, listener);
    }

    protected void fireEditingStopped() {
        if (list != null)
            list.editingStopped(new ChangeEvent(this));
    }

    protected void fireEditingCanceled() {
        if (list != null)
            list.editingCanceled(new ChangeEvent(this));
    }

    public void actionPerformed(ActionEvent event) {
        fireEditingStopped();
    }
}

