/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;


import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.util.CloseInterface;
import ch.abacus.lib.util.GlobalInterface;

import java.awt.*;
import java.util.HashMap;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 8:23:34 PM
 * To change this template use Options | File Templates.
 */
public class RendererFocusTree implements CloseInterface {
    private RendererFocusNode theRoot;
    private static HashMap quickAccess = new HashMap(500);
    public GlobalInterface theGlobalInterface;

    public RendererFocusTree(MetaObject theTopObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theRoot = new RendererFocusNode(theTopObject.getSwingObject());
        theRoot.addChildren(theTopObject);
        //ALEX
        if (theGlobalInterface != null) {
            theGlobalInterface.addToShutdownCollector(this);
        }
    }

    public RendererFocusTree(Object theRenderingObject, GlobalInterface _GlobalInterface) {
        this.theGlobalInterface = _GlobalInterface;
        theRoot = new RendererFocusNode(theRenderingObject);
        //ALEX
        if (theGlobalInterface != null) {
            theGlobalInterface.addToShutdownCollector(this);
        }
    }

    //ALEX
    public void close() {
        quickAccess.clear();

        if (theGlobalInterface != null) {
            theGlobalInterface.removeFromShutdownCollector(this);
        }
    }

    public static void addQuickAccess(RendererFocusNode rendererFocusNode, Object swingObject) {
        quickAccess.put(swingObject, rendererFocusNode);
        quickAccess.put(rendererFocusNode, swingObject);
    }

    public static Object getQuickAccess(Object key) {
        return quickAccess.get(key);
    }

    public RendererFocusNode getMatchingNode(Object component) {
        return (RendererFocusNode) getQuickAccess(component);
    }

    public void addFocus(Object parent, Object child) {
        RendererFocusNode parentNode = getMatchingNode(parent);
        RendererFocusNode childNode = new RendererFocusNode(child);
        // if we get a bad parent add the focus instead to the root.
        if (parentNode == null)
            parentNode = theRoot;
        parentNode.addChildNode(childNode);
        if (RendererFocusTraversalPolicy.getPolicyObject(child)) {
            Container theContainer = (Container) child;
            if (theContainer != null)
                theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
        }
    }

}
