/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 8:26:23 PM
 * To change this template use Options | File Templates.
 */
public class RendererFocusNode {
    Object swingObject;
    RendererFocusNode previousSibling;
    RendererFocusNode nextSibling;
    RendererFocusNode parent;
    RendererFocusNode firstChild;
    RendererFocusNode lastChild;

    public RendererFocusNode(Object swingObject) {
        this.swingObject = swingObject;
        RendererFocusTree.addQuickAccess(this, swingObject);
    }

    public void addChildren(MetaObject theObject) {
        if ((theObject.isFrame()) || (theObject.isPanel()) || (theObject.isAbalet()) ||
                (theObject.isTabPage()) || (theObject.isGroup())) {
            Container theContainer = (Container) theObject.getSwingObject();
            if (theContainer != null)
                theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
        }

        MetaObject theChild = theObject.theFirstChild;
        while (theChild != null) {
            RendererFocusNode childNode = new RendererFocusNode(theChild.getSwingObject());
            addChildNode(childNode);
            childNode.addChildren(theChild);
            theChild = theChild.getNextObject();
        }
    }

    public void addChildNode(RendererFocusNode theNode) {
        if (firstChild == null) {
            firstChild = theNode;
        } else {
            theNode.previousSibling = lastChild;
            lastChild.nextSibling = theNode;
        }
        theNode.parent = this;
        lastChild = theNode;
    }

    public boolean isFocusable() {
        if (swingObject instanceof Component) {
            return ((Component) swingObject).isFocusable();
        }
        return false;
    }

    public boolean isEnabled() {
        if (swingObject instanceof Component) {
            return ((Component) swingObject).isEnabled();
        }
        return false;
    }

    public Component next() {
        if (nextSibling != null) {
            // if component is focusable and enabled return it.
            // otherwise proceed to next.
            if (nextSibling.firstChild != null)
                return nextSibling.first();
            else {
                if (nextSibling.isFocusable() && nextSibling.isEnabled())
                    return (Component) nextSibling.swingObject;
                else
                    return nextSibling.next();
            }
        } else if (parent != null)
            return parent.next();
        else
            return null;
    }

    public Component previous() {
        if (previousSibling != null) {
            if (previousSibling.lastChild != null)
                return previousSibling.last();
            else {
                if (previousSibling.isFocusable() && previousSibling.isEnabled())
                    return (Component) previousSibling.swingObject;
                else
                    return previousSibling.previous();
            }
        } else if (parent != null)
            return parent.previous();
        else
            return null;
    }

    public Component first() {
        if (firstChild != null) {
            if (firstChild.firstChild != null)
                return firstChild.first();
            if (firstChild.isEnabled() && firstChild.isFocusable())
                return (Component) firstChild.swingObject;
            else
                return firstChild.next();
        }
        return null;
    }

    public Component last() {
        if (lastChild != null) {
            if (lastChild.lastChild != null)
                return lastChild.last();
            if (lastChild.isEnabled() && lastChild.isFocusable())
                return (Component) lastChild.swingObject;
            else
                return lastChild.previous();
        }
        return null;
    }

}
