/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:59:53 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:59:53 Misteli
 *
 * Last Modification:
 * $Id: PropertyInspectorCellRenderer.java,v 1.3 2005/09/06 13:55:29 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Component;

public class PropertyInspectorCellRenderer extends DefaultTableCellRenderer {

  private CategoryCellRenderer categoryRenderer;
  private BaseCellRenderer nameRenderer;

  public PropertyInspectorCellRenderer(JTable table) {
    categoryRenderer = new CategoryCellRenderer(table);
    nameRenderer = new PropertyNameCellRenderer(table);
  }

  public CategoryCellRenderer getCategoryRenderer() {
    return categoryRenderer;
  }

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    if (value instanceof DisplayGroup)
      return categoryRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    else
    if (value instanceof DisplayProperty) {
      DisplayProperty property = (DisplayProperty) value;
      JComponent component;
      switch (column) {
        case 0:
          component = (JComponent) nameRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
          component.setEnabled(property.isEnabled() && !property.getProperty().isReadOnly());
          if (((PropertyModel) table.getModel()).getSelection().size() > 1 && property.getProperty().isSingleSelection())
            component.setEnabled(false);
          component.setToolTipText(property.getHint());
          return component;
        case 1:
          if (property.getProperty().getRenderer() != null) {
            component = (JComponent) property.getProperty().getRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setEnabled(property.isEnabled() && !property.getProperty().isReadOnly() && !property.getProperty().isValueEditorReadOnly());
            if (((PropertyModel) table.getModel()).getSelection().size() > 1 && property.getProperty().isSingleSelection())
              component.setEnabled(false);
            component.setToolTipText(property.getHint());
            return component;
          }
      }
    }
    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
  }

}

