/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 15:42:22 Misteli
 *
 * Maintainer:
 * 18.04.2005 15:42:22 Misteli
 *
 * Last Modification:
 * $Id: PropertyBorder.java,v 1.3 2005/11/29 13:55:19 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.images.ImageLoader;
import ch.abacus.lib.ui.propertyinspector.core.Group;
import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;
import ch.abacus.lib.ui.propertyinspector.display.DisplayProperty;
import ch.abacus.lib.ui.propertyinspector.display.PropertyModel;

import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class PropertyBorder implements Border {

  private int level = 0;
  private int toggle = 0;
  private PropertyModel model;
  private Color background = UIManager.getColor("Panel.background");
  private Icon collapsedIcon = ImageLoader.getImageIcon("lnf/tree_collapsed.png");
  private Icon expandedIcon = ImageLoader.getImageIcon("lnf/tree_expanded.png");

  public PropertyBorder(PropertyModel model) {
    this.model = model;
  }

  public void init(DisplayProperty property) {
    toggle = 0;
    if (model.isGrouped())
      calculateLevel(property.getProperty().getGroup());
    else
      level = 0;
  }

  public void init(DisplayGroup group) {
    if (group.getGroup() == null || group.getGroup().isFolded())
      toggle = 2;
    else
      toggle = 1;
    if (model.isGrouped())
      calculateLevel(group.getGroup());
    else
      level = 0;
  }

  private void calculateLevel(Group group) {
    level = 0;
    while (group != null) {
      level++;
      group = group.getParent();
    }
  }

  public boolean isBorderOpaque() {
    return false;
  }

  public Insets getBorderInsets(Component c) {
    return new Insets(1, level * expandedIcon.getIconWidth() + 6, 1, 1);
  }

  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    Color oldColor = g.getColor();
    g.setColor(background);
    g.fillRect(x, y, x + level * expandedIcon.getIconWidth() + 4, y + height);
    switch (toggle) {
      case 1:
        expandedIcon.paintIcon(c, g, x + 2 + (level - 1) * expandedIcon.getIconHeight(), y + (height - expandedIcon.getIconHeight()) / 2);
        break;
      case 2:
        collapsedIcon.paintIcon(c, g, x + 2 + (level - 1) * expandedIcon.getIconHeight(), y + (height - collapsedIcon.getIconHeight()) / 2);
        break;
    }
    g.setColor(oldColor);
  }
}
