/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 15:42:56 Misteli
 *
 * Maintainer:
 * 18.04.2005 15:42:56 Misteli
 *
 * Last Modification:
 * $Id: CategoryCellRenderer.java,v 1.2 2005/09/02 14:35:39 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.propertyinspector.core.GroupEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.DisplayGroup;

import javax.swing.JTable;
import javax.swing.border.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

public class CategoryCellRenderer extends BaseCellRenderer {

  private Color textColor = background.darker();
  private IconLabel label = new IconLabel();
  private Border nullBorder = BorderFactory.createEmptyBorder();

  public CategoryCellRenderer(JTable table) {
    super(table);
    font = table.getFont().deriveFont(Font.BOLD);
  }

  public IconLabel getLabel() {
    return label;
  }

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    initialize(label, table, false, false, row, column);
    label.setBackground(background);
    label.setForeground(textColor);
    DisplayGroup displayGroup = (DisplayGroup) value;
    label.setToolTipText(displayGroup.getGroup().getHint());
    switch (column) {
      case 0:
        label.setIcon(null);
        label.setText(displayGroup.getGroup().getName());
        label.setBorder(border);
        label.setFont(font);
        border.init(displayGroup);
        break;
      case 1:
        GroupEditorInterface editor = displayGroup.getGroup().getEditor();
        if (editor != null && editor.isVisible(displayGroup.getGroup())) {
          label.setIcon(editor.getIcon());
          label.setHint(editor.getHint());
        }
        else {
          label.setIcon(null);
          label.setHint(null);
        }
        label.setBorder(nullBorder);
        label.setText("");
        break;
    }
    return label;
  }

}
