/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 25.04.2005 16:42:04 Misteli
 *
 * Maintainer:
 * 25.04.2005 16:42:04 Misteli
 *
 * Last Modification:
 * $Id: PropertyDefinitionInterface.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import java.util.ArrayList;

/** The PropertyDefinitionInterfaceis used to add new Property Definitions to a class. It is seldom used, but can be used
 * to define properties to a class where otherwise these properties should not be visible.
 * For example, a Clazz might define properties for a physical class where the physical class does not always define
 * a physical member class where the properties can be retrieved from. Hence, addPropertyDefinition could be used to
 * dynamically add properties to a class.
 */
public interface PropertyDefinitionInterface {

  /**
   * addPropertyDefinition is called when the property inspector needs to display all properties of a class or selection of classes
   * in the property editor.
   * @param objects the list of physical objects that are selected..
   * @param properties the DisplayProperties (that is, the visible properties of the PropertyInspector) that are defined right now.
   */
  public void addPropertyDefinition(ArrayList<ObjectInstance> objects, DisplayProperties properties);
}
