/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 14:13:29 Misteli
 *
 * Maintainer:
 * 18.04.2005 14:13:29 Misteli
 *
 * Last Modification:
 * $Id: HeaderlessColumnResizer.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class HeaderlessColumnResizer extends MouseInputAdapter {

  private static Cursor resizeCursor =
  Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR);

  private int mouseXOffset;
  private Cursor otherCursor = resizeCursor;

  private JTable table;

  public HeaderlessColumnResizer(JTable table) {
    this.table = table;
    table.addMouseListener(this);
    table.addMouseMotionListener(this);
  }

  private boolean canResize(TableColumn column) {
    return (column != null) && table.getTableHeader().getResizingAllowed() && column.getResizable();
  }

  private TableColumn getResizingColumn(Point p) {
    return getResizingColumn(p, table.columnAtPoint(p));
  }

  private TableColumn getResizingColumn(Point p, int column) {
    if (column == -1)
      return null;
    int row = table.rowAtPoint(p);
    Rectangle r = table.getCellRect(row, column, true);
    r.grow(-3, 0);
    if (r.contains(p))
      return null;
    int midPoint = r.x + r.width / 2;
    int columnIndex;
    if (table.getTableHeader().getComponentOrientation().isLeftToRight())
      columnIndex = (p.x < midPoint) ? column - 1 : column;
    else
      columnIndex = (p.x < midPoint) ? column : column - 1;
    if (columnIndex == -1)
      return null;
    return table.getTableHeader().getColumnModel().getColumn(columnIndex);
  }

  public void mousePressed(MouseEvent e) {
    table.getTableHeader().setDraggedColumn(null);
    table.getTableHeader().setResizingColumn(null);
    table.getTableHeader().setDraggedDistance(0);

    Point p = e.getPoint();

    int index = table.columnAtPoint(p);

    if (index != -1) {
      TableColumn resizingColumn = getResizingColumn(p, index);
      if (canResize(resizingColumn)) {
        table.getTableHeader().setResizingColumn(resizingColumn);
        if (table.getTableHeader().getComponentOrientation().isLeftToRight())
          mouseXOffset = p.x - resizingColumn.getWidth();
        else
          mouseXOffset = p.x + resizingColumn.getWidth();
      }
    }
  }

  private void swapCursor() {
    Cursor tmp = table.getCursor();
    table.setCursor(otherCursor);
    otherCursor = tmp;
  }

  public void mouseMoved(MouseEvent e) {
    if (canResize(getResizingColumn(e.getPoint())) != (table.getCursor() == resizeCursor))
      swapCursor();
  }

  public void mouseDragged(MouseEvent e) {
    int mouseX = e.getX();

    TableColumn resizingColumn = table.getTableHeader().getResizingColumn();

    boolean headerLeftToRight =
    table.getTableHeader().getComponentOrientation().isLeftToRight();

    if (resizingColumn != null) {
      int oldWidth = resizingColumn.getWidth();
      int newWidth;
      if (headerLeftToRight)
        newWidth = mouseX - mouseXOffset;
      else
        newWidth = mouseXOffset - mouseX;
      resizingColumn.setWidth(newWidth);

      Container container;
      if (table.getTableHeader().getParent() == null ||
         (container = table.getTableHeader().getParent().getParent()) == null ||
         !(container instanceof JScrollPane))
        return;

      if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight) {
        if (table != null) {
          JViewport viewport = ((JScrollPane) container).getViewport();
          int viewportWidth = viewport.getWidth();
          int diff = newWidth - oldWidth;
          int newHeaderWidth = table.getWidth() + diff;

          Dimension tableSize = table.getSize();
          tableSize.width += diff;
          table.setSize(tableSize);

          if ((newHeaderWidth >= viewportWidth) && (table.getAutoResizeMode() == JTable.AUTO_RESIZE_OFF)) {
            Point p = viewport.getViewPosition();
            p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
            viewport.setViewPosition(p);
            mouseXOffset += diff;
          }
        }
      }
    }
  }

  public void mouseReleased(MouseEvent e) {
    table.getTableHeader().setResizingColumn(null);
    table.getTableHeader().setDraggedColumn(null);
  }

  public void mouseEntered(MouseEvent e) {
  }

  public void mouseExited(MouseEvent e) {
  }

}
