/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:32:44 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:32:44 Misteli
 *
 * Last Modification:
 * $Id: DisplayProperties.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

import ch.abacus.lib.ui.propertyinspector.core.BaseList;
import ch.abacus.lib.ui.propertyinspector.core.Property;

import java.util.Comparator;

public class DisplayProperties extends BaseList {

  public DisplayProperty get(int index) {
    return (DisplayProperty) list.get(index);
  }

  public DisplayProperty findByProperty(Property property, boolean createIfNotExists) {
    DisplayProperty p;
    for (int i=0; i<list.size(); i++) {
      p = get(i);
      if (p.getProperty() == property)
        return p;
    }
    if (createIfNotExists) {
      p = new DisplayProperty(property);
      add(p);
    }
    else
      p = null;
    return p;
  }

  public DisplayProperty findById(Enum id) {
    DisplayProperty p;
    for (int i=0; i<list.size(); i++) {
      p = get(i);
      if (p.getProperty().getId().equals(id))
        return p;
    }
    return null;
  }

  public void remove(DisplayProperty p) {
    list.remove(p);
  }

  public Comparator comparator(final boolean sortAlphabetically) {
    return new Comparator() {
      public int compare(Object o, Object o1) {
        if (!sortAlphabetically)
          return 0;
        DisplayProperty g1 = (DisplayProperty) o;
        DisplayProperty g2 = (DisplayProperty) o1;
        return g1.getProperty().getName().compareTo(g2.getProperty().getName());
      }
    };
  }
}
