/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 25.04.2005 13:49:25 Misteli
 *
 * Maintainer:
 * 25.04.2005 13:49:25 Misteli
 *
 * Last Modification:
 * $Id: DependenciesInterface.java,v 1.1 2005/09/02 14:26:05 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display;

/**
 * The DependenciesInterface is used to check dependencies between several properties. For example, in Fire, we have properties for
 * left, height and width. However, a field can be assigned to an aligner, both for its position as well as its size.
 * Hence, if assigned, the values for left and/or width will be taken from the aligner, not from these values which then makes
 * sense when we can disable the left and/or width properties since they don't make sense to the user anymore
 */
public interface DependenciesInterface {

  /**
   * Is called when a selection of objects has been selected and the property inspector needs to display them.
   * @param property The property for which the dependencies shall be checked..
   * @param currentValue the current value of the property
   * @param dependencies the dependencies that are defined for this property. See Property javadoc
   */
  public void checkDependencies(DisplayProperty property, Object currentValue, DisplayProperties dependencies);
}
