/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 16:54:16 Misteli
 *
 * Maintainer:
 * 15.04.2005 16:54:16 Misteli
 *
 * Last Modification:
 * $Id: BaseList.java,v 1.1 2005/09/02 14:26:04 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class BaseList {

  protected ArrayList list = new ArrayList();

  public int size() {
    return list.size();
  }

  public void add(Object object) {
    list.add(object);
  }

  public void clear() {
    list.clear();
  }

  public void sort(boolean sortAlphabetically) {
    Collections.sort(list, comparator(sortAlphabetically));
  }

  public void addAll(BaseList other) {
    list.addAll(other.list);
  }

  public abstract Comparator comparator(boolean sortAlphabetically);

}
