/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import java.awt.Component;
import java.awt.event.FocusListener;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;

/**
 *  Stub
 */
public class JARadioButton extends JRadioButton {

  /**
   * Creates an initially unselected radio button
   * with no set text.
   */
  public JARadioButton() {
    super();
  }

  /**
   * Creates an initially unselected radio button
   * with the specified image but no text.
   *
   * @param icon  the image that the button should display
   */
  public JARadioButton(Icon icon) {
    super(icon);
  }

  /**
   * Creates a radiobutton where properties are taken from the
   * Action supplied.
   *
   * @since 1.3
   */
  public JARadioButton(Action a) {
    super(a);
  }

  /**
   * Creates a radio button with the specified image
   * and selection state, but no text.
   *
   * @param icon  the image that the button should display
   * @param selected  if true, the button is initially selected;
   *                  otherwise, the button is initially unselected
   */
  public JARadioButton(Icon icon, boolean selected) {
    super(icon, selected);
  }

  /**
   * Creates an unselected radio button with the specified text.
   *
   * @param text  the string displayed on the radio button
   */
  public JARadioButton(String text) {
    super(text);
  }

  /**
   * Creates an unselected radio button with the specified text.and a specified mnemonic
   *
   * @param text  the string displayed on the radio button
   */
  public JARadioButton(String text, char mnemonic) {
    super(text);
  }


  /**
   * Creates a radio button with the specified text
   * and selection state.
   *
   * @param text  the string displayed on the radio button
   * @param selected  if true, the button is initially selected;
   *                  otherwise, the button is initially unselected
   */
  public JARadioButton(String text, boolean selected) {
    super(text, selected);
  }

  /**
   * Creates a radio button that has the specified text and image,
   * and that is initially unselected.
   *
   * @param text  the string displayed on the radio button
   * @param icon  the image that the button should display
   */
  public JARadioButton(String text, Icon icon) {
    super(text, icon);
  }

  /**
   * Creates a radio button that has the specified text, image,
   * and selection state.
   *
   * @param text  the string displayed on the radio button
   * @param icon  the image that the button should display
   */
  public JARadioButton(String text, Icon icon, boolean selected) {
    super(text, icon, selected);
  }
}