/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * JALayeredPane.java
 *
 * Creator:
 * 10.04.2003 22:09:12 Fritz
 *
 * Maintainer:
 * 10.04.2003 22:09:12 Fritz + Ivancic
 *
 * Last Modification:
 * $Id: JALayeredPane.java,v 1.1 2005/10/13 16:09:50 agraham Exp $
 *
 * This is the "Z-Ordered" Pane created for the AbaDesignCockpit by Martin Fritz and Hervo Ivancic @ Miami South Beach
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui;

import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.layout.AnchoringComponent;
import ch.abacus.lib.ui.layout.Anchoring;
//import ch.abacus.lib.db.AbstractTable;

import javax.swing.*;
import java.awt.*;

public class JALayeredPane extends JLayeredPane{
    /**
     * Private declarations
     */
    private Component m_cActiveComponent;

    /**
     * Constructor for the object, only calls the super class
     */
    public JALayeredPane() {
      super();
      setOpaque(true);
    }

    /**
     * Procedure for setting the active containter, needed because of special handling of containers in an AnchoringLayoutManager
     * @param comp
     * @param layer
     */
    public void setDisplayLayer(Component comp, int layer) {
        if (comp==null) return;
        Container container = comp.getParent();
        if (container instanceof JALayeredPane) {
            LayoutManager lm = container.getLayout();
            if (lm instanceof AnchoringLayoutManager) {
                // to do --> GetAnchoringSettings and SetThemAfterAddLayoutComponent
                AnchoringLayoutManager anchoringLayoutManager = (AnchoringLayoutManager)lm;
                AnchoringComponent anchoringComponent = anchoringLayoutManager.findAnchoringComponent(comp);
                if (anchoringComponent != null) {
                    String sName = anchoringComponent.name;
                    if (sName != null) {
                        ((JLayeredPane)container).setLayer(comp, layer);
                        anchoringLayoutManager.addLayoutComponent(sName, comp);
                        anchoringLayoutManager.setAnchoring(comp, (anchoringComponent.anchoring.anchoring & Anchoring.LEFT)!=0,
                                (anchoringComponent.anchoring.anchoring & Anchoring.RIGHT)!=0,
                                (anchoringComponent.anchoring.anchoring & Anchoring.TOP)!=0,
                                (anchoringComponent.anchoring.anchoring & Anchoring.BOTTOM)!=0);
                    }
                }
            }

        }
    }
    public void setBounds(int x, int y, int cx, int cy) {
        super.setBounds(x, y, cx, cy);
        //System.out.println("received set bounds x = "+x+" y = "+y+" cx = "+cx+" cy = "+cy);
    }

    /**
     * Interface for setting the active component - will be used by apllication programmers
     * @param NewActiveComponent
     */
    public void setActiveComponent(Component NewActiveComponent) {

      if (NewActiveComponent == null) return;

      if (m_cActiveComponent != null) {
          if (m_cActiveComponent.equals(NewActiveComponent)) return;
          setDisplayLayer(m_cActiveComponent, DEFAULT_LAYER.intValue());
      }

      setDisplayLayer(NewActiveComponent, DEFAULT_LAYER.intValue() + 1);

      m_cActiveComponent = NewActiveComponent;

    }

    /**
     * Resets all first level components on the LayeredPane to default value
     */
    public void resetAllFirstComponents(){
      int tempComponentCount = getComponentCount();
      Component tempComponent;
      for (int i=0; i < tempComponentCount; i++) {
          tempComponent = getComponent(i);
          if (tempComponent instanceof Component) {
            setDisplayLayer(tempComponent,DEFAULT_LAYER.intValue());
          }
      }
    }
}
