/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import ch.abacus.lib.util.math.IntMath;

import java.awt.*;

public class JAGradientPanel extends JAPanel {

    public static final Color DEFAULT_START_COLOR = new Color(254, 254, 254);

    private Color startColor = null;
    private Color endColor = null;
    private int colorCount = 100;

    private boolean topLine = false;

    public JAGradientPanel(LayoutManager layout) {
        super(layout);
        setBorder(BorderFactory.createEmptyBorder());
    }

    public int getColorCount() {
        return colorCount;
    }

    public void setColorCount(int count) {
        if(count > 0) colorCount = count;
    }

    public void setStartColor(Color color) {
        startColor = color;
    }
    public void setEndColor(Color color) {
        endColor = color;
    }

    public Color getStartColor() {
        if(startColor == null)
            return DEFAULT_START_COLOR;
        else
            return startColor;
    }

    public Color getEndColor() {
        if(endColor == null)
            return getBackground();
        else
            return endColor;
    }

    public boolean getTopLineEnabled() {
        return topLine;
    }

    public void setTopLineEnabled(boolean _Enabled) {
        topLine = _Enabled;
    }

    public void paint(Graphics gx) {
        Color ec = getEndColor();
        Color sc = getStartColor();
        int dr = ec.getRed() - sc.getRed();
        int dg = ec.getGreen() - sc.getGreen();
        int db = ec.getBlue() - sc.getBlue();

        int height = getHeight();
        int width = getWidth() / colorCount;
        int left = 0;

        gx.setColor(sc);
        if(colorCount == 1) {
            gx.fillRect(0, 0, getWidth(), height);
            return;
        } else {
            gx.fillRect(left, 0, width, height);
            left += width;
        }

        for(int i = 1; i < colorCount; i++) {
            int r = sc.getRed() + IntMath.mulDiv(i, dr, colorCount - 1);
            int g = sc.getGreen() + IntMath.mulDiv(i, dg, colorCount - 1);
            int b = sc.getBlue() + IntMath.mulDiv(i, db, colorCount - 1);

            gx.setColor(new Color(r, g, b));
            if(i < (colorCount - 1)) {
                gx.fillRect(left, 0, width, height);
            } else {
                gx.fillRect(left, 0, getWidth() - left, height);
            }
            left += width;
        }
        if(topLine) {
            gx.setColor(SystemColor.controlShadow);
            gx.drawLine(0, 0, getWidth(), 0);
        }
        paintChildren(gx);
    }
}