/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.*;
import java.net.URL;

public class JAButton extends JButton {

   public void setIcon(String paramIconPath) {
       URL u1=null;
       try { u1 = getClass().getClassLoader().getResource(paramIconPath); } catch (Exception e) { }
       if ( u1==null )
       {
           try { u1 = getClass().getResource(paramIconPath); } catch (Exception e) { }
       }
       ImageIcon icon = new ImageIcon(u1);
       setIcon(icon);
   }

  /**
   * Creates a button with no set text or icon.
   */
  public JAButton() {
    super();
  }
  /**
   * Creates a button with an icon.
   * @param icon  the Icon image to display on the button
   */
  public JAButton(Icon icon) {
    super(icon);
  }
  /**
   * Creates a button with text.
   * @param text  the text of the button
   */
  public JAButton(String text) {
    super(text);
  }

  /**
   * Creates a button with text.and a predefined mnemonic
   * @param text  the text of the button
   */
  public JAButton(String text, char mnemonic) {
    super(text);
    setMnemonic(mnemonic)    ;
  }

  /**
   * Creates a flat button with text.
   * @param text  the text of the button
   * @param flat  true if the button should be flat
   * @deprecated no longer needed, use other constructor instead
   */
  public JAButton(String text, boolean flat) {
    super(text, null);
  }

  /**
   * Creates a button where properties are taken from the
   * Action supplied.
   * @since 1.3
   */
  public JAButton(Action a) {
    super(a);
  }

  /**
   * Creates a button with initial text and an icon.
   * @param text  the text of the button.
   * @param icon  the Icon image to display on the button
   */
  public JAButton(String text, Icon icon) {
    super(text, icon);
  }

    /**
     * Special call for the Opensource designcockpit to load an Image
     * For any questions regarding this method contact: mariohc@castellumtech.com
     */

    public void setImageIcon ( String paramIconPath ) {
        URL u1 = null;
        try {
            u1 = getClass ().getClassLoader ().getResource ( paramIconPath );
        } catch ( Exception e ) {
        }
        if ( u1 == null ) {
            try {
                u1 = getClass ().getResource ( paramIconPath );
            } catch ( Exception e ) {
            }
        }
        ImageIcon icon = null;
        if ( u1 == null )
            icon = new ImageIcon ( paramIconPath );
        else
            icon = new ImageIcon ( u1 );
        setIcon ( icon );
    }
}

