/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.core;

import com.l2fprod.common.application.core.ActionUpdater;
import com.l2fprod.common.application.core.Command;
import com.l2fprod.common.application.core.CommandContext;
import com.l2fprod.common.application.core.DefaultActionUpdater;
import com.l2fprod.common.application.core.UpdateableAction;
import com.l2fprod.common.util.OS;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

class DefaultAction
extends AbstractAction
implements UpdateableAction {
    private String enablesFor;
    private Class objectType;
    private String commandClass;
    private ActionUpdater updater;

    private Command newCommand() {
        try {
            Command command = (Command)Class.forName(this.commandClass).newInstance();
            return command;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't construct command " + this.commandClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't construct commmand " + this.commandClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find command " + this.commandClass, e);
        }
    }

    public final void actionPerformed(ActionEvent e) {
        CommandContext context = (CommandContext)this.getValue("commandContext");
        this.newCommand().execute(context);
    }

    public final void update(CommandContext context) {
        this.getUpdater().update(this, context);
    }

    public void setId(String value) {
        this.putValue("id", value);
    }

    public String getId() {
        return (String)this.getValue("id");
    }

    public void setText(String text) {
        this.putValue("Name", text);
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setMnemonic(char mnemonic) {
        this.putValue("mnemonic", new Character(mnemonic));
    }

    public char getMnemonic() {
        Character mnemonic = (Character)this.getValue("mnemonic");
        if (mnemonic == null) {
            return '\u0000';
        }
        return mnemonic.charValue();
    }

    public void setCommand(String commandClass) {
        this.commandClass = commandClass;
    }

    public String getCommand() {
        return this.commandClass;
    }

    public void setObjectType(String objectClass) {
        try {
            this.objectType = Class.forName(objectClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find object type", e);
        }
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public void setEnablesFor(String enablesFor) {
        this.enablesFor = enablesFor;
    }

    public void setUpdater(String updaterClass) {
        try {
            this.updater = (ActionUpdater)Class.forName(updaterClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can't construct updater " + updaterClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't construct updater " + updaterClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find updater " + updaterClass, e);
        }
    }

    public void setAccelerator(String accel) {
        String acceleratorString = OS.isMacOSX() ? accel.replaceAll("menukey", "meta") : accel.replaceAll("menukey", "ctrl");
        KeyStroke accelerator = KeyStroke.getKeyStroke(acceleratorString);
        this.putValue("AcceleratorKey", accelerator);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    private ActionUpdater getUpdater() {
        if (this.updater == null) {
            this.updater = this.objectType == null && this.enablesFor != null ? new DefaultActionUpdater(this.enablesFor) : (this.objectType != null ? new DefaultActionUpdater(this.objectType, this.enablesFor) : ActionUpdater.SET_ENABLED_TRUE);
        }
        return this.updater;
    }

    public String toString() {
        return super.toString() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "id=" + this.getId() + ",text=" + this.getText() + ",mnemonic=" + this.getMnemonic() + ",command=" + this.getCommand() + ",enablesFor=" + this.enablesFor + ",acccel=" + this.getAccelerator();
    }
}

